/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.transformer.graph.ConverterFilter;

public class CompositeConverterFilter
implements ConverterFilter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConverterFilter[] filters;

    public CompositeConverterFilter(ConverterFilter ... filters) {
        this.filters = filters;
    }

    @Override
    public List<Converter> filter(List<Converter> converters, DataType<?> source, DataType<?> result) {
        List<Converter> filteredTransformers = new LinkedList<Converter>(converters);
        for (ConverterFilter filter : this.filters) {
            if (filteredTransformers.size() <= 1) break;
            filteredTransformers = filter.filter(filteredTransformers, source, result);
        }
        return filteredTransformers;
    }
}

