/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException {
        ObjectSerializer serializer = this.muleContext.getObjectSerializer();
        try {
            Object result = src instanceof byte[] ? serializer.deserialize((byte[])src) : serializer.deserialize((InputStream)src);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

