/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AbstractCounter;
import org.mule.util.counters.impl.AggregateCounter;

public class Operator
extends AggregateCounter {
    private final Counter base2;
    private double val1;
    private double val2;

    public Operator(String name, AbstractCounter base, AbstractCounter base2, CounterFactory.Type type) {
        super(name, type, base);
        this.base2 = base2;
        base2.addAggregate(this);
    }

    @Override
    public double nextValue() {
        CounterFactory.Type type = this.getType();
        if (type == CounterFactory.Type.PLUS) {
            return this.val1 + this.val2;
        }
        if (type == CounterFactory.Type.MINUS) {
            return this.val1 - this.val2;
        }
        if (type == CounterFactory.Type.MULTIPLY) {
            return this.val1 * this.val2;
        }
        if (type == CounterFactory.Type.DIVIDE) {
            return this.val2 == 0.0 ? (this.val1 >= 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : this.val1 / this.val2;
        }
        throw new IllegalStateException();
    }

    @Override
    public void doCompute() {
        this.val1 = this.getBase().nextValue();
        this.val2 = this.base2.nextValue();
    }
}

