/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.mule.api.MuleRuntimeException;
import org.mule.util.FileUtils;

public class QueueFileProvider {
    public static final String OPEN_FILE_OPTIONS = "rws";
    public static final String UTF_8_ENCODING = "UTF-8";
    private final boolean newFile;
    private File file;
    private RandomAccessFile queueFile;

    public QueueFileProvider(File storeDirectory, String fileName) {
        this.file = new File(storeDirectory, fileName);
        this.newFile = !this.file.exists();
        try {
            this.createQueueFile();
        }
        catch (IOException e) {
            this.file = new File(storeDirectory, QueueFileProvider.toHex(fileName));
            try {
                this.createQueueFile();
            }
            catch (IOException e2) {
                throw new MuleRuntimeException(e2);
            }
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.queueFile;
    }

    private void createQueueFile() throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.queueFile = new RandomAccessFile(this.file, OPEN_FILE_OPTIONS);
    }

    private static String toHex(String filename) {
        try {
            return new BigInteger(filename.getBytes(UTF_8_ENCODING)).toString(16);
        }
        catch (UnsupportedEncodingException e) {
            return filename;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void recreate() throws IOException {
        this.delete();
        this.createQueueFile();
    }

    public void delete() {
        FileUtils.deleteQuietly((File)this.file);
    }

    public void close() throws IOException {
        this.queueFile.close();
    }

    public boolean isNewFile() {
        return this.newFile;
    }
}

