/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.apache.commons.collections.Factory;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;

public class ProvidedObjectStoreWrapper<T extends Serializable>
implements ObjectStore<T>,
Disposable {
    private ObjectStore<T> wrapped;
    private final boolean provided;

    public ProvidedObjectStoreWrapper(ObjectStore<T> providedObjectStore, Factory objectStoreFactory) {
        if (providedObjectStore == null) {
            this.provided = false;
            this.wrapped = (ObjectStore)objectStoreFactory.create();
        } else {
            this.provided = true;
            this.wrapped = providedObjectStore;
        }
    }

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getWrapped().contains(key);
    }

    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        this.getWrapped().store(key, value);
    }

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        return this.getWrapped().retrieve(key);
    }

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        return this.getWrapped().remove(key);
    }

    @Override
    public boolean isPersistent() {
        return this.getWrapped().isPersistent();
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.getWrapped().clear();
    }

    @Override
    public void dispose() {
        if (!this.provided && this.wrapped != null && this.wrapped instanceof Disposable) {
            ((Disposable)((Object)this.wrapped)).dispose();
        }
        this.wrapped = null;
    }

    protected ObjectStore<T> getWrapped() {
        return this.wrapped;
    }
}

