/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;

public class SDCNN
extends SDOps {
    public SDCNN(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable avgPooling2d(SDVariable input, Pooling2DConfig pooling2DConfig) {
        return this.avgPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable avgPooling2d(String name, SDVariable input, Pooling2DConfig pooling2DConfig) {
        SDValidation.validateFloatingPoint("avgPooling2d", input);
        SDVariable ret = this.f().avgPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable avgPooling3d(SDVariable input, Pooling3DConfig pooling3DConfig) {
        return this.avgPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable avgPooling3d(String name, SDVariable input, Pooling3DConfig pooling3DConfig) {
        SDValidation.validateFloatingPoint("avgPooling3d", input);
        SDVariable ret = this.f().avgPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchToSpace(SDVariable x, int[] blocks, int[][] crops) {
        return this.batchToSpace(null, x, blocks, crops);
    }

    public SDVariable batchToSpace(String name, SDVariable x, int[] blocks, int[][] crops) {
        SDValidation.validateNumerical("batchToSpace", x);
        SDVariable ret = this.f().batchToSpace(x, blocks, crops);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable col2Im(SDVariable in, Conv2DConfig config) {
        return this.col2Im(null, in, config);
    }

    public SDVariable col2Im(String name, SDVariable in, Conv2DConfig config) {
        SDVariable ret = this.f().col2Im(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv1d(SDVariable input, SDVariable weights, Conv1DConfig conv1DConfig) {
        return this.conv1d(null, input, weights, conv1DConfig);
    }

    public SDVariable conv1d(String name, SDVariable input, SDVariable weights, Conv1DConfig conv1DConfig) {
        SDValidation.validateFloatingPoint("conv1d", input);
        SDValidation.validateFloatingPoint("conv1d", weights);
        SDVariable ret = this.f().conv1d(input, weights, conv1DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, Conv2DConfig config) {
        return this.conv2d(layerInput, weights, null, config);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, Conv2DConfig config) {
        SDValidation.validateFloatingPoint("conv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("conv2d", "weights", weights);
        SDValidation.validateFloatingPoint("conv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.conv2d(arr, config);
    }

    public SDVariable conv2d(SDVariable[] inputs, Conv2DConfig config) {
        return this.conv2d(null, inputs, config);
    }

    public SDVariable conv2d(String name, SDVariable[] inputs, Conv2DConfig config) {
        for (SDVariable v : inputs) {
            SDValidation.validateNumerical("conv2d", v);
        }
        SDVariable ret = this.f().conv2d(inputs, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, Conv3DConfig conv3DConfig) {
        return this.conv3d(null, input, weights, null, conv3DConfig);
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig conv3DConfig) {
        SDValidation.validateFloatingPoint("conv3d", "input", input);
        SDValidation.validateFloatingPoint("conv3d", "weights", weights);
        SDValidation.validateFloatingPoint("conv3d", "bias", bias);
        SDVariable[] args = bias == null ? new SDVariable[]{input, weights} : new SDVariable[]{input, weights, bias};
        SDVariable ret = this.f().conv3d(args, conv3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig conv3DConfig) {
        return this.conv3d(null, input, weights, bias, conv3DConfig);
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, Conv3DConfig conv3DConfig) {
        return this.conv3d(name, input, weights, null, conv3DConfig);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, DeConv2DConfig deconv2DConfig) {
        return this.deconv2d(layerInput, weights, null, deconv2DConfig);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, DeConv2DConfig deconv2DConfig) {
        SDValidation.validateFloatingPoint("deconv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("deconv2d", "weights", weights);
        SDValidation.validateFloatingPoint("deconv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.deconv2d(arr, deconv2DConfig);
    }

    public SDVariable deconv2d(SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        return this.deconv2d(null, inputs, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        for (SDVariable v : inputs) {
            SDValidation.validateNumerical("deconv2d", v);
        }
        SDVariable ret = this.f().deconv2d(inputs, deconv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable deconv3d(String name, SDVariable input, SDVariable weights, SDVariable bias, DeConv3DConfig config) {
        SDValidation.validateFloatingPoint("conv3d", input);
        SDValidation.validateFloatingPoint("conv3d", weights);
        SDValidation.validateFloatingPoint("conv3d", bias);
        SDVariable ret = this.f().deconv3d(input, weights, bias, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthToSpace(SDVariable x, int blockSize, String dataFormat) {
        return this.depthToSpace(null, x, blockSize, dataFormat);
    }

    public SDVariable depthToSpace(String name, SDVariable x, int blockSize, String dataFormat) {
        SDVariable ret = this.f().depthToSpace(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, Conv2DConfig config) {
        return this.depthWiseConv2d(layerInput, depthWeights, null, config);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable bias, Conv2DConfig config) {
        SDValidation.validateFloatingPoint("depthwiseConv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("depthwiseConv2d", "depth weights", depthWeights);
        SDValidation.validateFloatingPoint("depthwiseConv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.depthWiseConv2d(arr, config);
    }

    public SDVariable depthWiseConv2d(SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        return this.depthWiseConv2d(null, inputs, depthConv2DConfig);
    }

    public SDVariable depthWiseConv2d(String name, SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        for (SDVariable v : inputs) {
            SDValidation.validateFloatingPoint("depthWiseConv2d", v);
        }
        SDVariable ret = this.f().depthWiseConv2d(inputs, depthConv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable dilation2D(SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        return this.dilation2D(null, df, weights, strides, rates, isSameMode);
    }

    public SDVariable dilation2D(String name, SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        SDVariable ret = this.f().dilation2D(df, weights, strides, rates, isSameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable extractImagePatches(String name, SDVariable input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        SDVariable ret = this.f().extractImagePatches(input, kH, kW, sH, sW, rH, rW, sameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable im2Col(SDVariable in, Conv2DConfig config) {
        return this.im2Col(null, in, config);
    }

    public SDVariable im2Col(String name, SDVariable in, Conv2DConfig config) {
        SDVariable ret = this.f().im2Col(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable localResponseNormalization(SDVariable inputs, LocalResponseNormalizationConfig lrnConfig) {
        return this.localResponseNormalization(null, inputs, lrnConfig);
    }

    public SDVariable localResponseNormalization(String name, SDVariable input, LocalResponseNormalizationConfig lrnConfig) {
        SDValidation.validateFloatingPoint("local response normalization", input);
        SDVariable ret = this.f().localResponseNormalization(input, lrnConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling2d(SDVariable input, Pooling2DConfig pooling2DConfig) {
        return this.maxPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable maxPooling2d(String name, SDVariable input, Pooling2DConfig pooling2DConfig) {
        SDValidation.validateNumerical("maxPooling2d", input);
        SDVariable ret = this.f().maxPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling3d(SDVariable input, Pooling3DConfig pooling3DConfig) {
        return this.maxPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable maxPooling3d(String name, SDVariable input, Pooling3DConfig pooling3DConfig) {
        SDValidation.validateNumerical("maxPooling3d", input);
        SDVariable ret = this.f().maxPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, Conv2DConfig config) {
        return this.separableConv2d(layerInput, depthWeights, pointWeights, null, config);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, Conv2DConfig config) {
        SDValidation.validateFloatingPoint("separableConv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateFloatingPoint("separableConv2d", "pointWeights", pointWeights);
        SDValidation.validateFloatingPoint("separableConv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 3 : 4];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        arr[2] = pointWeights;
        if (bias != null) {
            arr[3] = bias;
        }
        return this.sconv2d(arr, config);
    }

    public SDVariable sconv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        return this.sconv2d(null, inputs, conv2DConfig);
    }

    public SDVariable sconv2d(String name, SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        for (SDVariable v : inputs) {
            SDValidation.validateFloatingPoint("sconv2d", v);
        }
        SDVariable ret = this.f().sconv2d(inputs, conv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToBatch(SDVariable x, int[] blocks, int[][] padding) {
        return this.spaceToBatch(null, x, blocks, padding);
    }

    public SDVariable spaceToBatch(String name, SDVariable x, int[] blocks, int[][] padding) {
        SDVariable ret = this.f().spaceToBatch(x, blocks, padding);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToDepth(SDVariable x, int blockSize, String dataFormat) {
        return this.spaceToDepth(null, x, blockSize, dataFormat);
    }

    public SDVariable spaceToDepth(String name, SDVariable x, int blockSize, String dataFormat) {
        SDVariable ret = this.f().spaceToDepth(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable upsampling2d(SDVariable input, int scale) {
        return this.upsampling2d(null, input, true, scale, scale);
    }

    public SDVariable upsampling2d(String name, SDVariable input, boolean nchw, int scaleH, int scaleW) {
        SDVariable ret = this.f().upsampling2d(input, nchw, scaleH, scaleW);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable upsampling2d(String name, SDVariable input, int scale) {
        return this.upsampling2d(name, input, true, scale, scale);
    }

    public SDVariable upsampling2d(SDVariable input, boolean nchw, int scaleH, int scaleW) {
        return this.upsampling2d(null, input, nchw, scaleH, scaleW);
    }
}

