/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Swish;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SwishDerivative;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class ActivationSwish
extends BaseActivationFunction {
    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        Nd4j.getExecutioner().execAndReturn(new Swish(in));
        return in;
    }

    @Override
    public Pair<INDArray, INDArray> backprop(INDArray in, INDArray epsilon) {
        this.assertShape(in, epsilon);
        INDArray dLdz = Nd4j.getExecutioner().exec(new SwishDerivative(in));
        dLdz.muli(epsilon);
        return new Pair((Object)dLdz, null);
    }

    public String toString() {
        return "swish";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationSwish)) {
            return false;
        }
        ActivationSwish other = (ActivationSwish)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationSwish;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

