/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class MMulTranspose
implements Serializable {
    private static MMulTranspose allFalse = MMulTranspose.builder().build();
    private boolean transposeA;
    private boolean transposeB;
    private boolean transposeResult;

    public MMulTranspose(boolean transposeA, boolean transposeB, boolean transposeResult) {
        this.transposeA = transposeA;
        this.transposeB = transposeB;
        this.transposeResult = transposeResult;
    }

    public static MMulTranspose allFalse() {
        return allFalse;
    }

    public INDArray exec(INDArray a, INDArray b, INDArray result) {
        a = MMulTranspose.transposeIfReq(this.transposeA, a);
        b = MMulTranspose.transposeIfReq(this.transposeB, b);
        if (result == null) {
            INDArray ret = a.mmul(b);
            return MMulTranspose.transposeIfReq(this.transposeResult, ret);
        }
        if (!this.transposeResult) {
            return a.mmuli(b, result);
        }
        return a.mmuli(b, result).transpose();
    }

    private static INDArray transposeIfReq(boolean transpose, INDArray x) {
        if (transpose) {
            if (x.rank() == 2) {
                return x.transpose();
            }
            if (x.rank() == 3) {
                return x.permute(0, 2, 1);
            }
        }
        return x;
    }

    public static MMulTransposeBuilder builder() {
        return new MMulTransposeBuilder();
    }

    public boolean isTransposeA() {
        return this.transposeA;
    }

    public boolean isTransposeB() {
        return this.transposeB;
    }

    public boolean isTransposeResult() {
        return this.transposeResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MMulTranspose)) {
            return false;
        }
        MMulTranspose other = (MMulTranspose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTransposeA() != other.isTransposeA()) {
            return false;
        }
        if (this.isTransposeB() != other.isTransposeB()) {
            return false;
        }
        return this.isTransposeResult() == other.isTransposeResult();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MMulTranspose;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransposeA() ? 79 : 97);
        result = result * 59 + (this.isTransposeB() ? 79 : 97);
        result = result * 59 + (this.isTransposeResult() ? 79 : 97);
        return result;
    }

    public static class MMulTransposeBuilder {
        private boolean transposeA;
        private boolean transposeB;
        private boolean transposeResult;

        MMulTransposeBuilder() {
        }

        public MMulTransposeBuilder transposeA(boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public MMulTransposeBuilder transposeB(boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public MMulTransposeBuilder transposeResult(boolean transposeResult) {
            this.transposeResult = transposeResult;
            return this;
        }

        public MMulTranspose build() {
            return new MMulTranspose(this.transposeA, this.transposeB, this.transposeResult);
        }

        public String toString() {
            return "MMulTranspose.MMulTransposeBuilder(transposeA=" + this.transposeA + ", transposeB=" + this.transposeB + ", transposeResult=" + this.transposeResult + ")";
        }
    }
}

