/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

public class INDArrayStatistics {
    private double minValue;
    private double maxValue;
    private double meanValue;
    private double stdDevValue;
    private long countPositive;
    private long countNegative;
    private long countZero;
    private long countInf;
    private long countNaN;

    public static INDArrayStatisticsBuilder builder() {
        return new INDArrayStatisticsBuilder();
    }

    public INDArrayStatistics(double minValue, double maxValue, double meanValue, double stdDevValue, long countPositive, long countNegative, long countZero, long countInf, long countNaN) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.meanValue = meanValue;
        this.stdDevValue = stdDevValue;
        this.countPositive = countPositive;
        this.countNegative = countNegative;
        this.countZero = countZero;
        this.countInf = countInf;
        this.countNaN = countNaN;
    }

    public INDArrayStatistics() {
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public double getStdDevValue() {
        return this.stdDevValue;
    }

    public long getCountPositive() {
        return this.countPositive;
    }

    public long getCountNegative() {
        return this.countNegative;
    }

    public long getCountZero() {
        return this.countZero;
    }

    public long getCountInf() {
        return this.countInf;
    }

    public long getCountNaN() {
        return this.countNaN;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMeanValue(double meanValue) {
        this.meanValue = meanValue;
    }

    public void setStdDevValue(double stdDevValue) {
        this.stdDevValue = stdDevValue;
    }

    public void setCountPositive(long countPositive) {
        this.countPositive = countPositive;
    }

    public void setCountNegative(long countNegative) {
        this.countNegative = countNegative;
    }

    public void setCountZero(long countZero) {
        this.countZero = countZero;
    }

    public void setCountInf(long countInf) {
        this.countInf = countInf;
    }

    public void setCountNaN(long countNaN) {
        this.countNaN = countNaN;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof INDArrayStatistics)) {
            return false;
        }
        INDArrayStatistics other = (INDArrayStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMinValue(), other.getMinValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxValue(), other.getMaxValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMeanValue(), other.getMeanValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getStdDevValue(), other.getStdDevValue()) != 0) {
            return false;
        }
        if (this.getCountPositive() != other.getCountPositive()) {
            return false;
        }
        if (this.getCountNegative() != other.getCountNegative()) {
            return false;
        }
        if (this.getCountZero() != other.getCountZero()) {
            return false;
        }
        if (this.getCountInf() != other.getCountInf()) {
            return false;
        }
        return this.getCountNaN() == other.getCountNaN();
    }

    protected boolean canEqual(Object other) {
        return other instanceof INDArrayStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minValue = Double.doubleToLongBits(this.getMinValue());
        result = result * 59 + (int)($minValue >>> 32 ^ $minValue);
        long $maxValue = Double.doubleToLongBits(this.getMaxValue());
        result = result * 59 + (int)($maxValue >>> 32 ^ $maxValue);
        long $meanValue = Double.doubleToLongBits(this.getMeanValue());
        result = result * 59 + (int)($meanValue >>> 32 ^ $meanValue);
        long $stdDevValue = Double.doubleToLongBits(this.getStdDevValue());
        result = result * 59 + (int)($stdDevValue >>> 32 ^ $stdDevValue);
        long $countPositive = this.getCountPositive();
        result = result * 59 + (int)($countPositive >>> 32 ^ $countPositive);
        long $countNegative = this.getCountNegative();
        result = result * 59 + (int)($countNegative >>> 32 ^ $countNegative);
        long $countZero = this.getCountZero();
        result = result * 59 + (int)($countZero >>> 32 ^ $countZero);
        long $countInf = this.getCountInf();
        result = result * 59 + (int)($countInf >>> 32 ^ $countInf);
        long $countNaN = this.getCountNaN();
        result = result * 59 + (int)($countNaN >>> 32 ^ $countNaN);
        return result;
    }

    public String toString() {
        return "INDArrayStatistics(minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", meanValue=" + this.getMeanValue() + ", stdDevValue=" + this.getStdDevValue() + ", countPositive=" + this.getCountPositive() + ", countNegative=" + this.getCountNegative() + ", countZero=" + this.getCountZero() + ", countInf=" + this.getCountInf() + ", countNaN=" + this.getCountNaN() + ")";
    }

    public static class INDArrayStatisticsBuilder {
        private double minValue;
        private double maxValue;
        private double meanValue;
        private double stdDevValue;
        private long countPositive;
        private long countNegative;
        private long countZero;
        private long countInf;
        private long countNaN;

        INDArrayStatisticsBuilder() {
        }

        public INDArrayStatisticsBuilder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public INDArrayStatisticsBuilder maxValue(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public INDArrayStatisticsBuilder meanValue(double meanValue) {
            this.meanValue = meanValue;
            return this;
        }

        public INDArrayStatisticsBuilder stdDevValue(double stdDevValue) {
            this.stdDevValue = stdDevValue;
            return this;
        }

        public INDArrayStatisticsBuilder countPositive(long countPositive) {
            this.countPositive = countPositive;
            return this;
        }

        public INDArrayStatisticsBuilder countNegative(long countNegative) {
            this.countNegative = countNegative;
            return this;
        }

        public INDArrayStatisticsBuilder countZero(long countZero) {
            this.countZero = countZero;
            return this;
        }

        public INDArrayStatisticsBuilder countInf(long countInf) {
            this.countInf = countInf;
            return this;
        }

        public INDArrayStatisticsBuilder countNaN(long countNaN) {
            this.countNaN = countNaN;
            return this;
        }

        public INDArrayStatistics build() {
            return new INDArrayStatistics(this.minValue, this.maxValue, this.meanValue, this.stdDevValue, this.countPositive, this.countNegative, this.countZero, this.countInf, this.countNaN);
        }

        public String toString() {
            return "INDArrayStatistics.INDArrayStatisticsBuilder(minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", meanValue=" + this.meanValue + ", stdDevValue=" + this.stdDevValue + ", countPositive=" + this.countPositive + ", countNegative=" + this.countNegative + ", countZero=" + this.countZero + ", countInf=" + this.countInf + ", countNaN=" + this.countNaN + ")";
        }
    }
}

