/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.controlflow.compat;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.BaseCompatOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Enter
extends BaseCompatOp {
    protected boolean isConstant;

    @Override
    public String opName() {
        return "enter";
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.arg().getArr() != null) {
            return Collections.singletonList(LongShapeDescriptor.fromShape(this.arg().getShape(), this.arg().getArr().dataType()));
        }
        return Collections.emptyList();
    }

    @Override
    public SDVariable[] outputVariables() {
        return super.outputVariables();
    }

    @Override
    public String tensorflowName() {
        return "Enter";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.ENTER;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        this.isConstant = attributesForNode.get("is_constant").getB();
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return inputDataTypes;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Enter)) {
            return false;
        }
        Enter other = (Enter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isConstant() == other.isConstant();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Enter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConstant() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "Enter(isConstant=" + this.isConstant() + ")";
    }
}

