/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.controlflow.compat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.BaseCompatOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Switch
extends BaseCompatOp {
    public Switch(SameDiff sameDiff, SDVariable input, SDVariable predicate) {
        super(sameDiff, new SDVariable[]{input, predicate});
    }

    public Switch() {
    }

    @Override
    public String opName() {
        return "switch";
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.args()[0].getArr() != null) {
            SDVariable arg0 = this.args()[0];
            INDArray arr0 = arg0.getArr();
            DataType dtype = arr0.dataType();
            return Arrays.asList(LongShapeDescriptor.fromShape(arg0.getShape(), dtype), LongShapeDescriptor.fromShape(arg0.getShape(), dtype));
        }
        return Collections.emptyList();
    }

    @Override
    public SDVariable[] outputVariables() {
        return super.outputVariables();
    }

    @Override
    public String tensorflowName() {
        return "Switch";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.IF;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
    }

    @Override
    public int getNumOutputs() {
        return 2;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 input dataypes for %s, got %s", this.getClass(), inputDataTypes);
        Preconditions.checkState((inputDataTypes.get(1) == DataType.BOOL ? 1 : 0) != 0, (String)"Input datatype 1 (predicate) should be bool for %s, got %s", this.getClass(), inputDataTypes);
        return Arrays.asList(inputDataTypes.get(0), inputDataTypes.get(0));
    }
}

