/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conv2DDerivative
extends Conv2D {
    private static final Logger log = LoggerFactory.getLogger(Conv2DDerivative.class);

    public Conv2DDerivative(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig config) {
        super(sameDiff, inputFunctions, inputArrays, outputs, config);
    }

    public Conv2DDerivative() {
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No op name found for backwards.");
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No op name found for backwards");
    }

    @Override
    public String[] tensorflowNames() {
        throw new NoOpNameFoundException("No op name found for backwards");
    }

    @Override
    public String opName() {
        return "conv2d_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    @Override
    public int getNumOutputs() {
        if (this.args().length == 4) {
            return 3;
        }
        return 2;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        ArrayList<DataType> out = new ArrayList<DataType>(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            out.add(inputDataTypes.get(i));
        }
        return out;
    }

    public static Conv2DDerivativeBuilder derivativeBuilder() {
        return new Conv2DDerivativeBuilder();
    }

    public static class Conv2DDerivativeBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig config;

        Conv2DDerivativeBuilder() {
        }

        public Conv2DDerivativeBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv2DDerivativeBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv2DDerivativeBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Conv2DDerivativeBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Conv2DDerivativeBuilder config(Conv2DConfig config) {
            this.config = config;
            return this;
        }

        public Conv2DDerivative build() {
            return new Conv2DDerivative(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.config);
        }

        public String toString() {
            return "Conv2DDerivative.Conv2DDerivativeBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", config=" + this.config + ")";
        }
    }
}

