/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.IntArrayIntIndexAdpater;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.FullConv3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.FullConv3DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullConv3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(FullConv3D.class);
    protected FullConv3DConfig config;

    public FullConv3D(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputs, INDArray[] outputs, FullConv3DConfig config) {
        super(null, sameDiff, inputFunctions, false);
        this.config = config;
        if (inputs != null) {
            this.addInputArgument(inputs);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addArgs();
    }

    public FullConv3D() {
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        LinkedHashMap<String, Map<String, AttributeAdapter>> ret = new LinkedHashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, IntArrayIntIndexAdpater> tfAdapters = new LinkedHashMap<String, IntArrayIntIndexAdpater>();
        tfAdapters.put("dT", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("dW", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("dH", new IntArrayIntIndexAdpater(3));
        tfAdapters.put("pT", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("pW", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("pH", new IntArrayIntIndexAdpater(3));
        ret.put(this.tensorflowName(), tfAdapters);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"dT", "dW", "dH"}).build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dD", "dH", "dW"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pT", "pW", "pH"}).build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        PropertyMapping outputPadding = PropertyMapping.builder().propertyNames(new String[]{"aT", "aH", "aW"}).build();
        PropertyMapping biasUsed = PropertyMapping.builder().propertyNames(new String[]{"biasUsed"}).build();
        for (PropertyMapping propertyMapping : new PropertyMapping[]{strideMapping, dilationMapping, sameMode, paddingWidthHeight, dataFormat, outputPadding, biasUsed}) {
            for (String keys : propertyMapping.getPropertyNames()) {
                map.put(keys, propertyMapping);
            }
        }
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    private void addArgs() {
        this.addIArgument(this.config.getDT(), this.config.getDW(), this.config.getDH(), this.config.getPT(), this.config.getPW(), this.config.getPH(), this.config.getDilationT(), this.config.getDilationW(), this.config.getDilationH(), this.config.getAT(), this.config.getAW(), this.config.getAH(), ArrayUtil.fromBoolean((boolean)this.config.isBiasUsed()));
    }

    @Override
    public String opName() {
        return "fullconv3d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.addAll(f1);
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        FullConv3DDerivative fullConv3DDerivative = FullConv3DDerivative.derivativeBuilder().conv3DConfig(this.config).sameDiff(this.sameDiff).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(fullConv3DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static FullConv3DBuilder builder() {
        return new FullConv3DBuilder();
    }

    public static class FullConv3DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputs;
        private INDArray[] outputs;
        private FullConv3DConfig config;

        FullConv3DBuilder() {
        }

        public FullConv3DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public FullConv3DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public FullConv3DBuilder inputs(INDArray[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public FullConv3DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public FullConv3DBuilder config(FullConv3DConfig config) {
            this.config = config;
            return this;
        }

        public FullConv3D build() {
            return new FullConv3D(this.sameDiff, this.inputFunctions, this.inputs, this.outputs, this.config);
        }

        public String toString() {
            return "FullConv3D.FullConv3DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputs=" + Arrays.deepToString(this.inputs) + ", outputs=" + Arrays.deepToString(this.outputs) + ", config=" + this.config + ")";
        }
    }
}

