/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;

public class SigmoidCrossEntropyLoss
extends BaseLoss {
    public static final double DEFAULT_LABEL_SMOOTHING = 0.0;
    private double labelSmoothing = 0.0;

    public SigmoidCrossEntropyLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable logits, SDVariable weights, SDVariable labels, double labelSmoothing) {
        super(sameDiff, lossReduce, logits, weights, labels);
        this.labelSmoothing = labelSmoothing;
        this.addArgs();
    }

    public SigmoidCrossEntropyLoss(SameDiff sameDiff, LossReduce reductionMode, SDVariable logits, SDVariable weights, SDVariable labels) {
        this(sameDiff, reductionMode, logits, weights, labels, 0.0);
    }

    @Override
    public void addArgs() {
        super.addArgs();
        this.addTArgument(this.labelSmoothing);
    }

    @Override
    public String opName() {
        return "sigm_cross_entropy_loss";
    }

    @Override
    public String tensorflowName() {
        return "sigmoid_cross_entropy";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable[] grads = this.f().lossSigmoidCrossEntropyBp(this.arg(2), this.arg(0), this.arg(1), this.lossReduce, this.labelSmoothing);
        return Arrays.asList(grads);
    }

    public SigmoidCrossEntropyLoss() {
    }
}

