/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce3;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.reduce3.BaseReduce3Op;
import org.nd4j.linalg.factory.Nd4j;

public class EuclideanDistance
extends BaseReduce3Op {
    public static final String OP_NAME = "euclidean";

    public EuclideanDistance(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public EuclideanDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public EuclideanDistance() {
    }

    public EuclideanDistance(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, null, dimensions);
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z) {
        this(x, y, z, null);
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public EuclideanDistance(INDArray x, INDArray y, boolean allDistances, int ... dimensions) {
        this(x, y, null, allDistances, dimensions);
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, boolean allDistances, int ... dimensions) {
        this(x, y, z, false, allDistances, dimensions);
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, boolean keepDims, boolean allDistances, int ... dimensions) {
        super(x, y, z, keepDims, allDistances, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String opName() {
        return OP_NAME;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable euc = this.outputVariables()[0];
        SDVariable difference = this.larg().sub(this.rarg());
        SDVariable divBroadcastable = i_v1.get(0).div(euc);
        if (!(this.keepDims || this.dimensions == null || this.dimensions.length == 0 || this.dimensions.length == 1 && this.dimensions[0] == Integer.MAX_VALUE)) {
            divBroadcastable = this.f().reductionBroadcastableWithOrigShape(this.arg(), this.sameDiff.constant(Nd4j.createFromArray(this.dimensions)), divBroadcastable);
        }
        SDVariable gradX = difference.mul(divBroadcastable);
        SDVariable gradY = this.f().neg(gradX);
        return Arrays.asList(gradX, gradY);
    }
}

