/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class LayerNormBp
extends DynamicCustomOp {
    private boolean noBias = false;

    public LayerNormBp(SameDiff sameDiff, SDVariable input, SDVariable gain, SDVariable bias, SDVariable gradient, int ... dimensions) {
        super(null, sameDiff, new SDVariable[]{input, gain, bias, gradient}, false);
        Preconditions.checkArgument((bias != null ? 1 : 0) != 0, (String)"LayerNormBp: Use constructor without bias argument if bias is null / not available.");
        this.setDimensions(dimensions);
    }

    public LayerNormBp(INDArray input, INDArray gain, INDArray bias, INDArray grad, INDArray dLdx, INDArray dLdg, INDArray dLdb, int ... dimensions) {
        super("layer_norm_bp", new INDArray[]{input, gain, bias, grad}, new INDArray[]{dLdx, dLdg, dLdb});
        Preconditions.checkArgument((bias != null ? 1 : 0) != 0, (String)"LayerNormBp: Use constructor without bias argument if bias is null / not available.");
        this.setDimensions(dimensions);
    }

    public LayerNormBp(SameDiff sameDiff, SDVariable input, SDVariable gain, SDVariable gradient, int ... dimensions) {
        super(null, sameDiff, new SDVariable[]{input, gain, gradient}, false);
        this.noBias = true;
        this.setDimensions(dimensions);
    }

    public LayerNormBp(INDArray input, INDArray gain, INDArray grad, INDArray dLdx, INDArray dLdg, int ... dimensions) {
        super("layer_norm_bp", new INDArray[]{input, gain, grad}, new INDArray[]{dLdx, dLdg});
        this.noBias = true;
        this.setDimensions(dimensions);
    }

    @Override
    public void setDimensions(int[] dimensions) {
        Preconditions.checkArgument((dimensions != null ? 1 : 0) != 0, (String)"LayerNormBp: You have to provide dimensions");
        Preconditions.checkArgument((dimensions.length > 0 ? 1 : 0) != 0, (String)"LayerNormBp: You have to provide dimensions");
        this.dimensions = dimensions;
        this.addIArgument(dimensions);
    }

    @Override
    public String opName() {
        return "layer_norm_bp";
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow name found for shape " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() >= 3 && dataTypes.size() <= 4 ? 1 : 0) != 0, (String)"Expected exactly 3 or 4 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (DataType dataType : dataTypes) {
            Preconditions.checkState((boolean)dataType.isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            Preconditions.checkState((first == dataType ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return dataTypes.subList(0, dataTypes.size() - 1);
    }

    @Override
    public int getNumOutputs() {
        return this.noBias ? 2 : 3;
    }

    public LayerNormBp() {
    }
}

