/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.options;

import lombok.NonNull;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.ND4JUnknownDataTypeException;
import org.tensorflow.framework.DataType;

public class ArrayOptionsHelper {
    public static final long ATYPE_SPARSE_BIT = 2L;
    public static final long ATYPE_COMPRESSED_BIT = 4L;
    public static final long ATYPE_EMPTY_BIT = 8L;
    public static final long DTYPE_COMPRESSED_BIT = 4L;
    public static final long DTYPE_HALF_BIT = 4096L;
    public static final long DTYPE_FLOAT_BIT = 8192L;
    public static final long DTYPE_DOUBLE_BIT = 16384L;
    public static final long DTYPE_INT_BIT = 131072L;
    public static final long DTYPE_LONG_BIT = 262144L;
    public static final long DTYPE_BOOL_BIT = 524288L;
    public static final long DTYPE_BYTE_BIT = 32768L;
    public static final long DTYPE_SHORT_BIT = 65536L;
    public static final long DTYPE_UTF8_BIT = 0x100000L;
    public static final long DTYPE_UNSIGNED_BIT = 0x800000L;

    public static boolean hasBitSet(long[] shapeInfo, long bit) {
        long opt = Shape.options(shapeInfo);
        return ArrayOptionsHelper.hasBitSet(opt, bit);
    }

    public static void setOptionBit(long[] storage, ArrayType type) {
        int length = Shape.shapeInfoLength(storage);
        storage[length - 3] = ArrayOptionsHelper.setOptionBit(storage[length - 3], type);
    }

    public static boolean hasBitSet(long storage, long bit) {
        return (storage & bit) == bit;
    }

    public static ArrayType arrayType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        if (ArrayOptionsHelper.hasBitSet(opt, 2L)) {
            return ArrayType.SPARSE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return ArrayType.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 8L)) {
            return ArrayType.EMPTY;
        }
        return ArrayType.DENSE;
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(long opt) {
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return org.nd4j.linalg.api.buffer.DataType.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4096L)) {
            return org.nd4j.linalg.api.buffer.DataType.HALF;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 8192L)) {
            return org.nd4j.linalg.api.buffer.DataType.FLOAT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 16384L)) {
            return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 131072L)) {
            return org.nd4j.linalg.api.buffer.DataType.INT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 262144L)) {
            return org.nd4j.linalg.api.buffer.DataType.LONG;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 524288L)) {
            return org.nd4j.linalg.api.buffer.DataType.BOOL;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 32768L)) {
            return ArrayOptionsHelper.hasBitSet(opt, 0x800000L) ? org.nd4j.linalg.api.buffer.DataType.UBYTE : org.nd4j.linalg.api.buffer.DataType.BYTE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 65536L)) {
            return org.nd4j.linalg.api.buffer.DataType.SHORT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 0x100000L)) {
            return org.nd4j.linalg.api.buffer.DataType.UTF8;
        }
        throw new ND4JUnknownDataTypeException("Unknown extras set: [" + opt + "]");
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        return ArrayOptionsHelper.dataType(opt);
    }

    public static long setOptionBit(long storage, org.nd4j.linalg.api.buffer.DataType type) {
        long bit = 0L;
        switch (type) {
            case HALF: {
                bit = 4096L;
                break;
            }
            case FLOAT: {
                bit = 8192L;
                break;
            }
            case DOUBLE: {
                bit = 16384L;
                break;
            }
            case INT: {
                bit = 131072L;
                break;
            }
            case LONG: {
                bit = 262144L;
                break;
            }
            case BOOL: {
                bit = 524288L;
                break;
            }
            case UBYTE: {
                storage |= 0x800000L;
            }
            case BYTE: {
                bit = 32768L;
                break;
            }
            case SHORT: {
                bit = 65536L;
                break;
            }
            case UTF8: {
                bit = 0x100000L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return storage |= bit;
    }

    public static long setOptionBit(long storage, ArrayType type) {
        long bit = 0L;
        switch (type) {
            case SPARSE: {
                bit = 2L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            case EMPTY: {
                bit = 8L;
                break;
            }
            default: {
                return storage;
            }
        }
        return storage |= bit;
    }

    public static org.nd4j.linalg.api.buffer.DataType convertToDataType(DataType dataType) {
        switch (dataType) {
            case DT_BOOL: {
                return org.nd4j.linalg.api.buffer.DataType.BOOL;
            }
            case DT_FLOAT: {
                return org.nd4j.linalg.api.buffer.DataType.FLOAT;
            }
            case DT_INT32: {
                return org.nd4j.linalg.api.buffer.DataType.INT;
            }
            case DT_INT64: {
                return org.nd4j.linalg.api.buffer.DataType.LONG;
            }
            case DT_INT8: {
                return org.nd4j.linalg.api.buffer.DataType.BYTE;
            }
            case DT_INT16: {
                return org.nd4j.linalg.api.buffer.DataType.SHORT;
            }
            case DT_DOUBLE: {
                return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
            }
            case DT_UINT8: {
                return org.nd4j.linalg.api.buffer.DataType.UBYTE;
            }
            case DT_HALF: {
                return org.nd4j.linalg.api.buffer.DataType.HALF;
            }
            case DT_STRING: {
                return org.nd4j.linalg.api.buffer.DataType.UTF8;
            }
        }
        throw new UnsupportedOperationException("Unknown TF data type: [" + dataType.name() + "]");
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(@NonNull String dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        switch (dataType) {
            case "int64": {
                return org.nd4j.linalg.api.buffer.DataType.LONG;
            }
            case "int32": {
                return org.nd4j.linalg.api.buffer.DataType.INT;
            }
            case "int16": {
                return org.nd4j.linalg.api.buffer.DataType.SHORT;
            }
            case "int8": {
                return org.nd4j.linalg.api.buffer.DataType.BYTE;
            }
            case "bool": {
                return org.nd4j.linalg.api.buffer.DataType.BOOL;
            }
            case "resource": 
            case "float32": {
                return org.nd4j.linalg.api.buffer.DataType.FLOAT;
            }
            case "float64": 
            case "double": {
                return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
            }
            case "string": {
                return org.nd4j.linalg.api.buffer.DataType.UTF8;
            }
            case "uint8": 
            case "ubyte": {
                return org.nd4j.linalg.api.buffer.DataType.UBYTE;
            }
        }
        throw new ND4JIllegalStateException("Unknown data type used: [" + dataType + "]");
    }
}

