/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.adapter;

import java.util.List;
import java.util.NoSuchElementException;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class SingletonDataSetIterator
implements DataSetIterator {
    private final DataSet dataSet;
    private boolean hasNext = true;
    private boolean preprocessed = false;
    private DataSetPreProcessor preProcessor;

    public SingletonDataSetIterator(DataSet multiDataSet) {
        this.dataSet = multiDataSet;
    }

    @Override
    public DataSet next(int num) {
        return this.next();
    }

    @Override
    public int inputColumns() {
        return 0;
    }

    @Override
    public int totalOutcomes() {
        return 0;
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return false;
    }

    @Override
    public void reset() {
        this.hasNext = true;
    }

    @Override
    public int batch() {
        return 0;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public DataSet next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No elements remaining");
        }
        this.hasNext = false;
        if (this.preProcessor != null && !this.preprocessed) {
            this.preProcessor.preProcess(this.dataSet);
            this.preprocessed = true;
        }
        return this.dataSet;
    }

    @Override
    public void remove() {
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
}

