/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.classimbalance;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.classimbalance.BaseUnderSamplingPreProcessor;

public class UnderSamplingByMaskingPreProcessor
extends BaseUnderSamplingPreProcessor
implements DataSetPreProcessor {
    private double targetMinorityDist;
    private int minorityLabel = 1;

    public UnderSamplingByMaskingPreProcessor(double targetDist, int windowSize) {
        if (targetDist > 0.5 || targetDist <= 0.0) {
            throw new IllegalArgumentException("Target distribution for the minorityLabel class has to be greater than 0 and no greater than 0.5. Target distribution of " + targetDist + "given");
        }
        this.targetMinorityDist = targetDist;
        this.tbpttWindowSize = windowSize;
    }

    public void overrideMinorityDefault() {
        this.minorityLabel = 0;
    }

    @Override
    public void preProcess(DataSet toPreProcess) {
        INDArray label = toPreProcess.getLabels();
        INDArray labelMask = toPreProcess.getLabelsMaskArray();
        INDArray sampledMask = this.adjustMasks(label, labelMask, this.minorityLabel, this.targetMinorityDist);
        toPreProcess.setLabelsMaskArray(sampledMask);
    }
}

