/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class InverseSchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialValue;
    private final double gamma;
    private final double power;

    public InverseSchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialValue") double initialValue, @JsonProperty(value="gamma") double gamma, @JsonProperty(value="power") double power) {
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.gamma = gamma;
        this.power = power;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        return this.initialValue / Math.pow(1.0 + this.gamma * (double)i, this.power);
    }

    @Override
    public ISchedule clone() {
        return new InverseSchedule(this.scheduleType, this.initialValue, this.gamma, this.power);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getPower() {
        return this.power;
    }

    public String toString() {
        return "InverseSchedule(scheduleType=" + (Object)((Object)this.getScheduleType()) + ", initialValue=" + this.getInitialValue() + ", gamma=" + this.getGamma() + ", power=" + this.getPower() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InverseSchedule)) {
            return false;
        }
        InverseSchedule other = (InverseSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType)) {
            return false;
        }
        if (Double.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
            return false;
        }
        return Double.compare(this.getPower(), other.getPower()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof InverseSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        long $initialValue = Double.doubleToLongBits(this.getInitialValue());
        result = result * 59 + (int)($initialValue >>> 32 ^ $initialValue);
        long $gamma = Double.doubleToLongBits(this.getGamma());
        result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
        long $power = Double.doubleToLongBits(this.getPower());
        result = result * 59 + (int)($power >>> 32 ^ $power);
        return result;
    }
}

