/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.serde.jackson.shaded;

import java.io.IOException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializerProvider;

public class NDArrayTextSerializer
extends JsonSerializer<INDArray> {
    public void serialize(INDArray arr, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("dataType", arr.dataType().toString());
        jg.writeArrayFieldStart("shape");
        for (int i = 0; i < arr.rank(); ++i) {
            jg.writeNumber(arr.size(i));
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("data");
        if (arr.isView() || arr.ordering() != 'c' || !Shape.hasDefaultStridesForShape(arr) || arr.isCompressed()) {
            arr = arr.dup('c');
        }
        switch (arr.dataType()) {
            case DOUBLE: {
                double[] d;
                for (double v : d = arr.data().asDouble()) {
                    jg.writeNumber(v);
                }
                break;
            }
            case FLOAT: 
            case HALF: {
                float[] f;
                for (float v : f = arr.data().asFloat()) {
                    jg.writeNumber(v);
                }
                break;
            }
            case LONG: {
                long[] l;
                for (long v : l = arr.data().asLong()) {
                    jg.writeNumber(v);
                }
                break;
            }
            case INT: 
            case SHORT: 
            case UBYTE: {
                int[] i;
                for (int v : i = arr.data().asInt()) {
                    jg.writeNumber(v);
                }
                break;
            }
            case BYTE: 
            case BOOL: {
                byte[] b;
                for (byte v : b = arr.data().asBytes()) {
                    jg.writeNumber((short)v);
                }
                break;
            }
            case UTF8: {
                String[] str = new String[(int)arr.length()];
                for (int j = 0; j < str.length; ++j) {
                    jg.writeString(arr.getString(j));
                }
                break;
            }
            case COMPRESSED: 
            case UNKNOWN: {
                throw new UnsupportedOperationException("Cannot JSON serialize array with datatype: " + arr.dataType());
            }
        }
        jg.writeEndArray();
        jg.writeEndObject();
    }
}

