/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.api.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FileBatch
implements Serializable {
    public static final String ORIGINAL_PATHS_FILENAME = "originalUris.txt";
    private final List<byte[]> fileBytes;
    private final List<String> originalUris;

    public static FileBatch readFromZip(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            FileBatch fileBatch = FileBatch.readFromZip(fis);
            return fileBatch;
        }
    }

    public static FileBatch readFromZip(InputStream is) throws IOException {
        String originalUris = null;
        HashMap<Integer, byte[]> bytesMap = new HashMap<Integer, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                byte[] bytes = IOUtils.toByteArray((InputStream)zis);
                if (name.equals(ORIGINAL_PATHS_FILENAME)) {
                    originalUris = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
                    continue;
                }
                int idxSplit = name.indexOf("_");
                int idxSplit2 = name.indexOf(".");
                int fileIdx = Integer.parseInt(name.substring(idxSplit + 1, idxSplit2));
                bytesMap.put(fileIdx, bytes);
            }
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(bytesMap.size());
        for (int i = 0; i < bytesMap.size(); ++i) {
            list.add((byte[])bytesMap.get(i));
        }
        List<String> origPaths = Arrays.asList(originalUris.split("\n"));
        return new FileBatch(list, origPaths);
    }

    public static FileBatch forFiles(File ... files) throws IOException {
        return FileBatch.forFiles(Arrays.asList(files));
    }

    public static FileBatch forFiles(List<File> files) throws IOException {
        ArrayList<String> origPaths = new ArrayList<String>(files.size());
        ArrayList<byte[]> bytes = new ArrayList<byte[]>(files.size());
        for (File f : files) {
            bytes.add(FileUtils.readFileToByteArray((File)f));
            origPaths.add(f.toURI().toString());
        }
        return new FileBatch(bytes, origPaths);
    }

    public void writeAsZip(File f) throws IOException {
        this.writeAsZip(new FileOutputStream(f));
    }

    public void writeAsZip(OutputStream os) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));){
            ZipEntry ze = new ZipEntry(ORIGINAL_PATHS_FILENAME);
            String originalUrisJoined = StringUtils.join(this.originalUris, (String)"\n");
            zos.putNextEntry(ze);
            zos.write(originalUrisJoined.getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < this.fileBytes.size(); ++i) {
                String ext = FilenameUtils.getExtension((String)this.originalUris.get(i));
                if (ext == null || ext.isEmpty()) {
                    ext = "bin";
                }
                String name = "file_" + i + "." + ext;
                ze = new ZipEntry(name);
                zos.putNextEntry(ze);
                zos.write(this.fileBytes.get(i));
            }
        }
    }

    public FileBatch(List<byte[]> fileBytes, List<String> originalUris) {
        this.fileBytes = fileBytes;
        this.originalUris = originalUris;
    }

    public List<byte[]> getFileBytes() {
        return this.fileBytes;
    }

    public List<String> getOriginalUris() {
        return this.originalUris;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileBatch)) {
            return false;
        }
        FileBatch other = (FileBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<byte[]> this$fileBytes = this.getFileBytes();
        List<byte[]> other$fileBytes = other.getFileBytes();
        if (this$fileBytes == null ? other$fileBytes != null : !((Object)this$fileBytes).equals(other$fileBytes)) {
            return false;
        }
        List<String> this$originalUris = this.getOriginalUris();
        List<String> other$originalUris = other.getOriginalUris();
        return !(this$originalUris == null ? other$originalUris != null : !((Object)this$originalUris).equals(other$originalUris));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileBatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<byte[]> $fileBytes = this.getFileBytes();
        result = result * 59 + ($fileBytes == null ? 43 : ((Object)$fileBytes).hashCode());
        List<String> $originalUris = this.getOriginalUris();
        result = result * 59 + ($originalUris == null ? 43 : ((Object)$originalUris).hashCode());
        return result;
    }

    public String toString() {
        return "FileBatch(fileBytes=" + this.getFileBytes() + ", originalUris=" + this.getOriginalUris() + ")";
    }
}

