/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextKeyAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextSortAscendingAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextSortKeyElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "sort-key");

    public TextSortKeyElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextKeyAttribute() {
        TextKeyAttribute attr = (TextKeyAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "key");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextKeyAttribute(String textKeyValue) {
        TextKeyAttribute attr = new TextKeyAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textKeyValue);
    }

    public Boolean getTextSortAscendingAttribute() {
        TextSortAscendingAttribute attr = (TextSortAscendingAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "sort-ascending");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.booleanValue();
        }
        return Boolean.valueOf("true");
    }

    public void setTextSortAscendingAttribute(Boolean textSortAscendingValue) {
        TextSortAscendingAttribute attr = new TextSortAscendingAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textSortAscendingValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

