/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.omnifaces.cdi.push.SocketEvent;
import org.omnifaces.cdi.push.SocketUserManager;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Hacks;

@ApplicationScoped
public class SocketSessionManager {
    private static final Logger logger = Logger.getLogger(SocketSessionManager.class.getName());
    private static final CloseReason REASON_EXPIRED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Expired");
    private static final long TOMCAT_WEB_SOCKET_RETRY_TIMEOUT = 10L;
    private static final long TOMCAT_WEB_SOCKET_MAX_RETRIES = 100L;
    private static final String WARNING_TOMCAT_WEB_SOCKET_BOMBED = "Tomcat cannot handle concurrent push messages. A push message has been sent only after %s retries of 10ms apart. Consider rate limiting sending push messages. For example, once every 500ms.";
    private static final String ERROR_TOMCAT_WEB_SOCKET_BOMBED = "Tomcat cannot handle concurrent push messages. A push message could NOT be sent after %s retries of 10ms apart. Consider rate limiting sending push messages. For example, once every 500ms.";
    private final ConcurrentHashMap<String, Collection<Session>> socketSessions = new ConcurrentHashMap();
    @Inject
    private SocketUserManager socketUsers;

    protected void register(String channelId) {
        if (!this.socketSessions.containsKey(channelId)) {
            this.socketSessions.putIfAbsent(channelId, new ConcurrentLinkedQueue());
        }
    }

    protected void register(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            this.register(channelId);
        }
    }

    protected boolean add(Session session) {
        String channelId = SocketSessionManager.getChannelId(session);
        Collection<Session> sessions = this.socketSessions.get(channelId);
        if (sessions != null && sessions.add(session)) {
            Serializable user = this.socketUsers.getUser(SocketSessionManager.getChannel(session), channelId);
            if (user != null) {
                session.getUserProperties().put("user", user);
            }
            SocketSessionManager.fireEvent(session, null, SocketEvent.Opened.LITERAL);
            return true;
        }
        return false;
    }

    protected Set<Future<Void>> send(String channelId, String message) {
        Collection<Session> sessions;
        Collection<Session> collection = sessions = channelId != null ? this.socketSessions.get(channelId) : null;
        if (sessions != null && !sessions.isEmpty()) {
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(sessions.size());
            for (Session session : sessions) {
                if (!session.isOpen()) continue;
                results.add(this.send(session, message, true));
            }
            return results;
        }
        return Collections.emptySet();
    }

    private Future<Void> send(Session session, String text, boolean retrySendTomcatWebSocket) {
        try {
            return session.getAsyncRemote().sendText(text);
        }
        catch (IllegalStateException e) {
            if (Hacks.isTomcatWebSocketBombed(session, e)) {
                if (retrySendTomcatWebSocket) {
                    return CompletableFuture.supplyAsync(() -> this.retrySendTomcatWebSocket(session, text));
                }
                return null;
            }
            throw e;
        }
    }

    private Void retrySendTomcatWebSocket(Session session, String text) {
        int retries = 0;
        Exception cause = null;
        try {
            while ((long)(++retries) < 100L) {
                Thread.sleep(10L);
                if (!session.isOpen()) {
                    throw new IllegalStateException("Too bad, session is now closed");
                }
                Future<Void> result = this.send(session, text, false);
                if (result == null) continue;
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, String.format(WARNING_TOMCAT_WEB_SOCKET_BOMBED, retries));
                }
                return result.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            cause = e;
        }
        catch (Exception e) {
            cause = e;
        }
        throw new UnsupportedOperationException(String.format(ERROR_TOMCAT_WEB_SOCKET_BOMBED, retries), cause);
    }

    protected void remove(Session session, CloseReason reason) {
        Collection<Session> sessions = this.socketSessions.get(SocketSessionManager.getChannelId(session));
        if (sessions != null && sessions.remove(session)) {
            SocketSessionManager.fireEvent(session, reason, SocketEvent.Closed.LITERAL);
        }
    }

    protected void deregister(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            Collection<Session> sessions = this.socketSessions.remove(channelId);
            if (sessions == null) continue;
            for (Session session : sessions) {
                this.close(session);
            }
        }
    }

    private void close(Session session) {
        if (session.isOpen()) {
            try {
                session.close(REASON_EXPIRED);
            }
            catch (IOException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; there is nothing more we could do here.", ignore);
            }
        }
    }

    static SocketSessionManager getInstance() {
        return Beans.getReference(SocketSessionManager.class, new Annotation[0]);
    }

    private static String getChannel(Session session) {
        return (String)session.getPathParameters().get("channel");
    }

    private static String getChannelId(Session session) {
        return SocketSessionManager.getChannel(session) + "?" + session.getQueryString();
    }

    private static void fireEvent(Session session, CloseReason reason, AnnotationLiteral<?> qualifier) {
        Serializable user = (Serializable)session.getUserProperties().get("user");
        Beans.fireEvent(new SocketEvent(SocketSessionManager.getChannel(session), user, null, reason != null ? reason.getCloseCode() : null), new Annotation[]{qualifier});
    }
}

