/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.viewscope;

import java.lang.annotation.Annotation;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.cdi.BeanStorage;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.viewscope.ViewScopeStorage;
import org.omnifaces.cdi.viewscope.ViewScopeStorageInSession;
import org.omnifaces.cdi.viewscope.ViewScopeStorageInViewState;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;

@ApplicationScoped
public class ViewScopeManager {
    public static final String PARAM_NAME_MAX_ACTIVE_VIEW_SCOPES = "org.omnifaces.VIEW_SCOPE_MANAGER_MAX_ACTIVE_VIEW_SCOPES";
    public static final String PARAM_NAME_MOJARRA_NUMBER_OF_VIEWS = "com.sun.faces.numberOfLogicalViews";
    public static final String PARAM_NAME_MYFACES_NUMBER_OF_VIEWS = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final int DEFAULT_MAX_ACTIVE_VIEW_SCOPES = 20;
    private static final Logger logger = Logger.getLogger(ViewScopeManager.class.getName());
    private static final String SCRIPT_INIT = "OmniFaces.Unload.init('%s')";
    private static final int DEFAULT_BEANS_PER_VIEW_SCOPE = 3;
    private static final String WARNING_UNSUPPORTED_STATE_SAVING = "@ViewScoped %s requires non-stateless views in order to be able to properly destroy the bean. The current view %s is stateless and this may cause memory leaks. Consider subclassing the bean with @javax.faces.view.ViewScoped annotation.";
    private static final String ERROR_INVALID_STATE_SAVING = "@ViewScoped(saveInViewState=true) %s requires web.xml context parameter 'javax.faces.STATE_SAVING_METHOD' being set to 'client'.";
    private static final String ERROR_VIEW_ALREADY_UNLOADED = "View %s was already unloaded.";
    @Inject
    private BeanManager manager;
    @Inject
    private ViewScopeStorageInSession storageInSession;
    @Inject
    private ViewScopeStorageInViewState storageInViewState;

    public <T> T createBean(Contextual<T> type, CreationalContext<T> context) {
        return this.getBeanStorage(type).createBean(type, context);
    }

    public <T> T getBean(Contextual<T> type) {
        return this.getBeanStorage(type).getBean(type);
    }

    public void preDestroyView() {
        FacesContext context = FacesContext.getCurrentInstance();
        UUID beanStorageId = null;
        if (ViewScopeManager.isUnloadRequest(context)) {
            try {
                beanStorageId = UUID.fromString(FacesLocal.getRequestParameter(context, "id"));
            }
            catch (Exception ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; this can only be a hacker attempt.", ignore);
                return;
            }
        } else if (FacesLocal.isAjaxRequestWithPartialRendering(context)) {
            context.getApplication().getResourceHandler().markResourceRendered(context, "omnifaces.js", "omnifaces");
        }
        if (BeansLocal.getInstance(this.manager, ViewScopeStorageInSession.class, false, new Annotation[0]) != null) {
            if (beanStorageId == null) {
                beanStorageId = this.storageInSession.getBeanStorageId();
            }
            if (beanStorageId != null) {
                this.storageInSession.destroyBeans(context, beanStorageId);
            }
        }
    }

    private <T> BeanStorage getBeanStorage(Contextual<T> type) {
        BeanStorage beanStorage;
        UUID beanStorageId;
        ViewScopeStorage storage = this.storageInSession;
        Class beanClass = ((Bean)type).getBeanClass();
        ViewScoped annotation = beanClass.getAnnotation(ViewScoped.class);
        if (annotation != null && annotation.saveInViewState()) {
            ViewScopeManager.checkStateSavingMethod(beanClass);
            storage = this.storageInViewState;
        }
        if ((beanStorageId = storage.getBeanStorageId()) == null) {
            beanStorageId = UUID.randomUUID();
            if (storage instanceof ViewScopeStorageInSession) {
                if (Faces.getViewRoot().isTransient()) {
                    logger.log(Level.WARNING, String.format(WARNING_UNSUPPORTED_STATE_SAVING, beanClass.getName(), Faces.getViewId()));
                } else {
                    ViewScopeManager.registerUnloadScript(beanStorageId);
                }
            }
        }
        if ((beanStorage = storage.getBeanStorage(beanStorageId)) == null) {
            FacesContext context;
            if (storage instanceof ViewScopeStorageInSession && FacesLocal.isPostback(context = FacesContext.getCurrentInstance()) && this.storageInSession.isRecentlyUnloaded(context)) {
                String viewId = context.getViewRoot().getViewId();
                throw new ViewExpiredException(String.format(ERROR_VIEW_ALREADY_UNLOADED, viewId), viewId);
            }
            beanStorage = new BeanStorage(3);
            storage.setBeanStorage(beanStorageId, beanStorage);
        }
        return beanStorage;
    }

    private static void checkStateSavingMethod(Class<?> beanClass) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.getApplication().getStateManager().isSavingStateInClient(context)) {
            throw new IllegalStateException(String.format(ERROR_INVALID_STATE_SAVING, beanClass.getName()));
        }
    }

    private static void registerUnloadScript(UUID beanStorageId) {
        Components.addFormIfNecessary();
        Components.addScriptResource("javax.faces", "jsf.js");
        Components.addScriptResource("omnifaces", "omnifaces.js");
        Components.addScript(String.format(SCRIPT_INIT, beanStorageId));
    }

    public static boolean isUnloadRequest(FacesContext context) {
        return ViewScopeManager.isUnloadRequest(FacesLocal.getRequest(context));
    }

    public static boolean isUnloadRequest(HttpServletRequest request) {
        return "unload".equals(request.getParameter("omnifaces.event"));
    }
}

