/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.omnifaces.component.ParamHolder;

public class SimpleParam<T>
implements ParamHolder<T> {
    private String name;
    private T value;
    private Converter<T> converter;

    public SimpleParam() {
    }

    public SimpleParam(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public SimpleParam(String name, T value, Converter<T> converter) {
        this(name, value);
        this.converter = converter;
    }

    public SimpleParam(UIParameter param) {
        this.name = param.getName();
        if (param instanceof ParamHolder) {
            ParamHolder holder = (ParamHolder)param;
            this.value = holder.getLocalValue();
            this.converter = holder.getConverter();
        } else {
            this.value = param.getValue();
        }
    }

    public SimpleParam(ParamHolder<T> param) {
        this(param.getName(), param.getLocalValue(), param.getConverter());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T getLocalValue() {
        return this.value;
    }

    @Override
    public String getValue() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.converter == null && this.value != null) {
            this.converter = context.getApplication().createConverter(this.value.getClass());
        }
        if (this.converter != null) {
            UIParameter component = new UIParameter();
            component.setName(this.name);
            component.setValue(this.value);
            return this.converter.getAsString(context, (UIComponent)component, this.value);
        }
        return this.value != null ? this.value.toString() : null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Converter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }
}

