/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.omnifaces.el.ScopedRunner;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.model.SelectItemGroups")
public class SelectItemGroups
extends UISelectItems {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.model.SelectItemGroups";
    private static final String ERROR_EXPRESSION_DISALLOWED = "A value expression is disallowed on 'var' attribute of SelectItemGroups.";

    public void setValueExpression(String name, ValueExpression binding) {
        if ("var".equals(name)) {
            throw new IllegalArgumentException(ERROR_EXPRESSION_DISALLOWED);
        }
        super.setValueExpression(name, binding);
    }

    public Object getValue() {
        ArrayList groups = new ArrayList();
        this.createSelectItems((UIComponent)this, super.getValue(), SelectItemGroup::new, selectItemGroup -> {
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            for (UIComponent child : this.getChildren()) {
                if (child instanceof UISelectItems) {
                    this.createSelectItems(child, ((UISelectItems)child).getValue(), SelectItem::new, items::add);
                    continue;
                }
                if (!(child instanceof UISelectItem)) continue;
                items.add(SelectItemGroups.createSelectItem(child, null, SelectItem::new));
            }
            selectItemGroup.setSelectItems(items.toArray(new SelectItem[items.size()]));
            groups.add(selectItemGroup);
        });
        return groups;
    }

    private <S extends SelectItem> void createSelectItems(UIComponent component, Object values, Supplier<S> supplier, Consumer<S> callback) {
        Map attributes = component.getAttributes();
        String var = Utils.coalesce((String)attributes.get("var"), "item");
        Utils.forEach(values, value -> ScopedRunner.forEach(this.getFacesContext(), var, value, () -> SelectItemGroups.lambda$null$1(callback, component, attributes, value, (Supplier)supplier)));
    }

    private static <S extends SelectItem> S createSelectItem(UIComponent component, Object value, Supplier<S> supplier) {
        Map attributes = component.getAttributes();
        Object itemValue = SelectItemGroups.getItemValue(attributes, value);
        Object itemLabel = attributes.get("itemLabel");
        Object itemLabelEscaped = Utils.coalesce(attributes.get("itemEscaped"), attributes.get("itemLabelEscaped"));
        Object itemDisabled = attributes.get("itemDisabled");
        SelectItem selectItem = (SelectItem)supplier.get();
        selectItem.setValue(itemValue);
        selectItem.setLabel(String.valueOf(itemLabel != null ? itemLabel : selectItem.getValue()));
        selectItem.setEscape(itemLabelEscaped == null || Boolean.parseBoolean(itemLabelEscaped.toString()));
        selectItem.setDisabled(itemDisabled != null && Boolean.parseBoolean(itemDisabled.toString()));
        return (S)selectItem;
    }

    private static Object getItemValue(Map<String, Object> attributes, Object defaultValue) {
        Object itemValue = attributes.get("itemValue");
        return itemValue != null || attributes.containsKey("itemValue") ? itemValue : defaultValue;
    }

    private static /* synthetic */ void lambda$null$1(Consumer callback, UIComponent component, Map attributes, Object value, Supplier supplier) {
        callback.accept(SelectItemGroups.createSelectItem(component, SelectItemGroups.getItemValue(attributes, value), supplier));
    }
}

