/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.FacesComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import org.omnifaces.component.output.OutputFamily;
import org.omnifaces.filter.OnDemandResponseBufferFilter;
import org.omnifaces.servlet.BufferedHttpServletResponse;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.State;
import org.omnifaces.util.cache.CacheFactory;

@FacesComponent(value="org.omnifaces.component.output.Cache")
public class Cache
extends OutputFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.Cache";
    public static final String VALUE_SET = "org.omnifaces.cache.VALUE_SET";
    public static final String DEFAULT_SCOPE = "session";
    public static final String START_CONTENT_MARKER = "<!-- START CACHE FOR %s -->";
    public static final String END_CONTENT_MARKER = "<!-- END CACHE FOR %s -->";
    private static final String ERROR_NO_BUFFERED_RESPONSE = String.format("No buffered response found in request, but 'useBuffer' set to true. Check setting the '%s' context parameter or installing the '%s' filter manually.", "org.omnifaces.CACHE_INSTALL_BUFFER_FILTER", OnDemandResponseBufferFilter.class);
    private static final Class<? extends SystemEvent> PRE_RENDER = PreRenderViewEvent.class;
    private final State state = new State(this.getStateHelper());

    public Cache() {
        FacesContext context = FacesContext.getCurrentInstance();
        Events.subscribeToViewEvent(PRE_RENDER, () -> this.processPreRenderViewEvent(context));
    }

    private void processPreRenderViewEvent(FacesContext context) {
        if (!this.isDisabled() && this.isUseBuffer() && !this.hasCachedValue(context)) {
            BufferedHttpServletResponse bufferedResponse = (BufferedHttpServletResponse)((Object)Faces.getRequestAttribute("org.omnifaces.servlet.BUFFERED_RESPONSE"));
            if (bufferedResponse == null) {
                throw new IllegalStateException(ERROR_NO_BUFFERED_RESPONSE);
            }
            bufferedResponse.setPassThrough(false);
            Events.subscribeToRequestAfterPhase(PhaseId.RENDER_RESPONSE, () -> this.processPostRenderResponsePhase(context, bufferedResponse));
        }
    }

    private void processPostRenderResponsePhase(FacesContext context, BufferedHttpServletResponse bufferedResponse) {
        String content = null;
        try {
            content = this.getContentFromBuffer(bufferedResponse.getBufferAsString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (content != null) {
            this.cacheContent(context, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeChildren(FacesContext context) throws IOException {
        String childRendering;
        if (this.isDisabled()) {
            super.encodeChildren(context);
            return;
        }
        String key = this.getKeyWithDefault(context);
        ResponseWriter responseWriter = context.getResponseWriter();
        org.omnifaces.util.cache.Cache scopedCache = this.getCacheImpl(context);
        if (this.isReset()) {
            scopedCache.remove(key);
        }
        if ((childRendering = scopedCache.get(key)) == null) {
            StringWriter bufferWriter = new StringWriter();
            ResponseWriter bufferedResponseWriter = responseWriter.cloneWithWriter((Writer)bufferWriter);
            context.setResponseWriter(bufferedResponseWriter);
            try {
                if (this.isUseBuffer()) {
                    bufferedResponseWriter.write(this.getStartContentMarker());
                }
                super.encodeChildren(context);
                if (this.isUseBuffer()) {
                    bufferedResponseWriter.write(this.getEndContentMarker());
                }
            }
            finally {
                context.setResponseWriter(responseWriter);
            }
            childRendering = ((Object)bufferWriter).toString();
            this.cacheContent(context, scopedCache, key, childRendering);
        }
        responseWriter.write(childRendering);
    }

    public Serializable getCacheAttribute(FacesContext context, String name) {
        return this.getCacheImpl(context).getAttribute(this.getKeyWithDefault(context), name);
    }

    public void setCacheAttribute(FacesContext context, String name, Serializable value) {
        this.getCacheImpl(context).putAttribute(this.getKeyWithDefault(context), name, value, this.getTime());
    }

    protected boolean isVisitable(VisitContext visitContext) {
        FacesContext context = visitContext.getFacesContext();
        return this.isDisabled() || this.isCachedValueJustSet(context) || !this.hasCachedValue(context);
    }

    private void cacheContent(FacesContext context, String content) {
        this.cacheContent(context, CacheFactory.getCache(context, this.getScope()), this.getKeyWithDefault(context), content);
    }

    private void cacheContent(FacesContext context, org.omnifaces.util.cache.Cache scopedCache, String key, String content) {
        int time = this.getTime();
        if (time > 0) {
            scopedCache.put(key, content, time);
        } else {
            scopedCache.put(key, content);
        }
        context.getExternalContext().getRequestMap().put(VALUE_SET, Boolean.TRUE);
    }

    private String getKeyWithDefault(FacesContext context) {
        String key = this.getKey();
        if (key == null) {
            key = context.getViewRoot().getViewId() + "_" + this.getClientId(context);
        }
        return key;
    }

    private org.omnifaces.util.cache.Cache getCacheImpl(FacesContext context) {
        return CacheFactory.getCache(context, this.getScope());
    }

    private boolean isCachedValueJustSet(FacesContext context) {
        return Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get(VALUE_SET));
    }

    private boolean hasCachedValue(FacesContext context) {
        return CacheFactory.getCache(context, this.getScope()).get(this.getKeyWithDefault(context)) != null;
    }

    private String getStartContentMarker() {
        return String.format(START_CONTENT_MARKER, this.getClientId());
    }

    private String getEndContentMarker() {
        return String.format(END_CONTENT_MARKER, this.getClientId());
    }

    private String getContentFromBuffer(String buffer) {
        String endMarker;
        int endIndex;
        String startMarker = this.getStartContentMarker();
        int startIndex = buffer.indexOf(startMarker);
        if (startIndex != -1 && (endIndex = buffer.indexOf(endMarker = this.getEndContentMarker())) != -1) {
            return buffer.substring(startIndex + startMarker.length(), endIndex);
        }
        return null;
    }

    public String getKey() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.key));
    }

    public void setKey(String keyValue) {
        this.state.put((Serializable)((Object)PropertyKeys.key), keyValue);
    }

    public String getScope() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.scope), DEFAULT_SCOPE);
    }

    public void setScope(String scopeValue) {
        this.state.put((Serializable)((Object)PropertyKeys.scope), scopeValue);
    }

    public Integer getTime() {
        return (Integer)this.state.get((Serializable)((Object)PropertyKeys.time), -1);
    }

    public void setTime(Integer timeValue) {
        this.state.put((Serializable)((Object)PropertyKeys.time), timeValue);
    }

    public boolean isUseBuffer() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.useBuffer), Boolean.FALSE);
    }

    public void setUseBuffer(boolean useBufferValue) {
        this.state.put((Serializable)((Object)PropertyKeys.useBuffer), useBufferValue);
    }

    public boolean isReset() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.reset), Boolean.FALSE);
    }

    public void setReset(boolean resetValue) {
        this.state.put((Serializable)((Object)PropertyKeys.reset), resetValue);
    }

    public boolean isDisabled() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.disabled), Boolean.FALSE);
    }

    public void setDisabled(boolean disabledValue) {
        this.state.put((Serializable)((Object)PropertyKeys.disabled), disabledValue);
    }

    static enum PropertyKeys {
        key,
        scope,
        time,
        useBuffer,
        reset,
        disabled;

    }
}

