/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.search;

import java.util.HashSet;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.omnifaces.util.Components;
import org.omnifaces.util.Utils;

public class MessagesKeywordResolver
extends SearchKeywordResolver {
    private static final Logger logger = Logger.getLogger(MessagesKeywordResolver.class.getName());

    public static void register(Application application) {
        application.addSearchKeywordResolver((SearchKeywordResolver)new MessagesKeywordResolver());
    }

    public boolean isResolverForKeyword(SearchExpressionContext context, String keyword) {
        return "messages".equals(keyword);
    }

    public void resolve(SearchKeywordContext context, UIComponent component, String keyword) {
        UIForm form = Components.getClosestParent(component, UIForm.class);
        if (form != null) {
            final HashSet messageClientIds = new HashSet();
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context.getSearchExpressionContext().getFacesContext());
            form.visitTree(visitContext, (visit, child) -> {
                if (Utils.isOneInstanceOf(child.getClass(), UIMessage.class, UIMessages.class)) {
                    if (child.getId().startsWith("j_id")) {
                        logger.warning(String.format("@messages can only target message components with a fixed ID; auto generated ID %s encountered", child.getId()));
                    } else {
                        messageClientIds.add(child.getClientId());
                    }
                }
                return VisitResult.ACCEPT;
            });
            if (!messageClientIds.isEmpty()) {
                context.invokeContextCallback((UIComponent)new UIMessage(){

                    public String getClientId(FacesContext context) {
                        return String.join((CharSequence)" ", messageClientIds);
                    }
                });
            }
        }
        context.setKeywordResolved(true);
    }
}

