/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.FacesConverter;
import javax.faces.convert.NumberConverter;
import org.omnifaces.util.Utils;

@FacesConverter(value="omnifaces.ImplicitNumberConverter")
public class ImplicitNumberConverter
extends NumberConverter {
    private static final Pattern PATTERN_NUMBER = Pattern.compile("[\\d,.]+");

    public String getAsString(FacesContext context, UIComponent component, Object modelValue) {
        String symbol;
        DecimalFormat formatter;
        String string = super.getAsString(context, component, modelValue);
        if (string != null && (formatter = this.getFormatter()) != null && (symbol = this.getSymbol(formatter)) != null) {
            string = string.replace(symbol, "").trim();
        }
        return string;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String submittedValue) {
        String symbol;
        DecimalFormat formatter;
        String string = submittedValue;
        if (!Utils.isEmpty(string) && (formatter = this.getFormatter()) != null && !string.contains(symbol = this.getSymbol(formatter))) {
            string = PATTERN_NUMBER.matcher(formatter.format(0L)).replaceAll(submittedValue);
        }
        return super.getAsObject(context, component, string);
    }

    private boolean isPercent() {
        return "percent".equals(this.getType());
    }

    private boolean isCurrency() {
        return "currency".equals(this.getType());
    }

    private DecimalFormat getFormatter() {
        if (this.isPercent()) {
            return (DecimalFormat)NumberFormat.getPercentInstance(this.getLocale());
        }
        if (this.isCurrency()) {
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance(this.getLocale());
            String currencyCode = this.getCurrencyCode();
            String currencySymbol = this.getCurrencySymbol();
            if (currencyCode != null) {
                formatter.setCurrency(Currency.getInstance(currencyCode));
            } else if (currencySymbol != null) {
                DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
                symbols.setCurrencySymbol(currencySymbol);
                formatter.setDecimalFormatSymbols(symbols);
            }
            return formatter;
        }
        return null;
    }

    private String getSymbol(DecimalFormat formatter) {
        if (this.isPercent()) {
            return String.valueOf(formatter.getDecimalFormatSymbols().getPercent());
        }
        if (this.isCurrency()) {
            return formatter.getDecimalFormatSymbols().getCurrencySymbol();
        }
        return null;
    }
}

