/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.omnifaces.util.Callback;

public class ScopedRunner {
    private FacesContext context;
    private Map<String, Object> scopedVariables;
    private Map<String, Object> previousVariables = new HashMap<String, Object>();

    public ScopedRunner(FacesContext context) {
        this(context, new HashMap<String, Object>());
    }

    public ScopedRunner(FacesContext context, Map<String, Object> scopedVariables) {
        this.context = context;
        this.scopedVariables = scopedVariables;
    }

    public ScopedRunner with(String key, Object value) {
        this.scopedVariables.put(key, value);
        return this;
    }

    public void invoke(Callback.Void callback) {
        try {
            this.setNewScope();
            callback.invoke();
        }
        finally {
            this.restorePreviousScope();
        }
    }

    private void setNewScope() {
        this.previousVariables.clear();
        Map requestMap = this.context.getExternalContext().getRequestMap();
        for (Map.Entry<String, Object> entry : this.scopedVariables.entrySet()) {
            Object previousVariable = requestMap.put(entry.getKey(), entry.getValue());
            if (previousVariable == null) continue;
            this.previousVariables.put(entry.getKey(), previousVariable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePreviousScope() {
        try {
            Map requestMap = this.context.getExternalContext().getRequestMap();
            for (Map.Entry<String, Object> entry : this.scopedVariables.entrySet()) {
                Object previousVariable = this.previousVariables.get(entry.getKey());
                if (previousVariable != null) {
                    requestMap.put(entry.getKey(), previousVariable);
                    continue;
                }
                requestMap.remove(entry.getKey());
            }
        }
        finally {
            this.previousVariables.clear();
        }
    }

    public static void forEach(FacesContext context, String key, Object value, Runnable callback) {
        new ScopedRunner(context).with(key, value).invoke(callback::run);
    }
}

