/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.omnifaces.model.IterableDataModel;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Json;
import org.omnifaces.util.Utils;

public final class Converters {
    private static final String ERROR_NOT_AN_ARRAY = "The given type '%s' is not an array at all.";
    private static final String ERROR_INVALID_FRAGMENT_SIZE = "The given fragment size '%s' must be at least 1.";

    private Converters() {
    }

    public static <E> List<E> setToList(Set<E> set) {
        if (set == null) {
            return null;
        }
        return new ArrayList<E>(set);
    }

    public static <K, V> List<Map.Entry<K, V>> mapToList(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new ArrayList<Map.Entry<K, V>>(map.entrySet());
    }

    public static <E> List<E> iterableToList(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        return Utils.iterableToList(iterable);
    }

    public static <E> DataModel<E> iterableToModel(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        return new IterableDataModel<E>(iterable);
    }

    public static String joinArray(Object array, String separator) {
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(String.format(ERROR_NOT_AN_ARRAY, array.getClass()));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (i > 0 && separator != null) {
                builder.append(separator);
            }
            builder.append(Array.get(array, i));
        }
        return builder.toString();
    }

    public static <E> String joinCollection(Collection<E> collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (E element : collection) {
            if (i++ > 0 && separator != null) {
                builder.append(separator);
            }
            builder.append(element);
        }
        return builder.toString();
    }

    public static <K, V> String joinMap(Map<K, V> map, String pairSeparator, String entrySeparator) {
        if (map == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (i++ > 0 && entrySeparator != null) {
                builder.append(entrySeparator);
            }
            builder.append(entry.getKey());
            if (pairSeparator != null) {
                builder.append(pairSeparator);
            }
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public static Object[][] splitArray(Object array, int fragmentSize) {
        if (Utils.isEmpty(array)) {
            return new Object[0][];
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(String.format(ERROR_NOT_AN_ARRAY, array.getClass()));
        }
        if (fragmentSize < 1) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_FRAGMENT_SIZE, fragmentSize));
        }
        int sourceSize = Array.getLength(array);
        Object[][] arrays = new Object[(sourceSize + fragmentSize - 1) / fragmentSize][];
        int i = 0;
        int j = 0;
        while (i < sourceSize) {
            arrays[j] = new Object[Math.min(fragmentSize, sourceSize - i)];
            System.arraycopy(array, i, arrays[j], 0, arrays[j].length);
            i += fragmentSize;
            ++j;
        }
        return arrays;
    }

    public static <E> List<List<E>> splitList(List<E> list, int fragmentSize) {
        if (Utils.isEmpty(list)) {
            return Collections.emptyList();
        }
        if (fragmentSize < 1) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_FRAGMENT_SIZE, fragmentSize));
        }
        int sourceSize = list.size();
        ArrayList<List<List<E>>> lists = new ArrayList<List<List<E>>>((sourceSize + fragmentSize - 1) / fragmentSize);
        for (int i = 0; i < sourceSize; i += fragmentSize) {
            lists.add(list.subList(i, Math.min(i + fragmentSize, sourceSize)));
        }
        return lists;
    }

    public static String toJson(Object object) {
        return Json.encode(object);
    }

    public static String printStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }

    public static String convert(String converterId, Object object) {
        FacesContext context = Faces.getContext();
        return FacesLocal.createConverter(context, converterId).getAsString(context, UIComponent.getCurrentComponent((FacesContext)context), object);
    }
}

