/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Numbers {
    private static final int BYTES_1K = 1024;
    private static final int NUMBER_1K = 1000;
    private static final int PRECISION = 3;

    private Numbers() {
    }

    public static String formatBytes(Long bytes) {
        return Numbers.formatBaseUnit(bytes, 1024, 1, true, "B");
    }

    public static String formatCurrency(Number number, String currencySymbol) {
        if (number == null) {
            return null;
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance(Faces.getLocale());
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setCurrencySymbol(currencySymbol);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(number);
    }

    public static String formatNumber(Number number, String pattern) {
        if (number == null) {
            return null;
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Faces.getLocale());
        formatter.applyPattern(pattern);
        return formatter.format(number);
    }

    public static String formatNumberDefault(Number number) {
        return Numbers.formatNumberDefaultForLocale(number, Faces.getLocale());
    }

    public static String formatNumberDefaultForLocale(Number number, Object locale) {
        if (number == null) {
            return null;
        }
        return NumberFormat.getNumberInstance(Utils.parseLocale(locale)).format(number);
    }

    public static String formatPercent(Number number) {
        if (number == null) {
            return null;
        }
        return NumberFormat.getPercentInstance(Faces.getLocale()).format(number);
    }

    public static String formatThousands(Number number) {
        return Numbers.formatThousandsUnit(number, null);
    }

    public static String formatThousandsUnit(Number number, String unit) {
        return Numbers.formatBaseUnit(number, 1000, null, false, unit);
    }

    private static String formatBaseUnit(Number number, int base, Integer fractions, boolean iec, String unit) {
        BigDecimal decimal;
        if (number == null) {
            return null;
        }
        try {
            decimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return Numbers.formatBase(decimal, base, fractions, iec, unit);
    }

    private static String formatBase(BigDecimal decimal, int base, Integer fractions, boolean iec, String unit) {
        BigDecimal reparsed;
        int exponent = (int)(Math.log(decimal.abs().longValue()) / Math.log(base));
        BigDecimal divisor = BigDecimal.valueOf(Math.pow(base, exponent));
        BigDecimal divided = divisor.signum() == 0 ? divisor : decimal.divide(divisor);
        int maxfractions = fractions != null ? fractions : 3 - String.valueOf(divided.abs().longValue()).length();
        String format = "%." + maxfractions + "f";
        String formatted = String.format(Faces.getLocale(), format, divided);
        try {
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Faces.getLocale());
            formatter.setParseBigDecimal(true);
            reparsed = (BigDecimal)formatter.parse(formatted);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        if (reparsed.longValue() >= (long)base) {
            return Numbers.formatBase(reparsed, base, fractions, iec, unit);
        }
        return Numbers.formatUnit(formatted, iec, unit, exponent, maxfractions > 0 && (fractions == null || iec && exponent == 0));
    }

    private static String formatUnit(String formatted, boolean iec, String unit, int exponent, boolean stripZeroes) {
        if (stripZeroes) {
            formatted = formatted.replaceAll("\\D?0+$", "");
        }
        String separator = unit == null ? "" : " ";
        String unitString = unit == null ? "" : unit;
        return formatted + separator + Numbers.getUnitPrefix(iec, exponent) + unitString;
    }

    private static String getUnitPrefix(boolean iec, int exponent) {
        if (exponent < 1) {
            return "";
        }
        char unitPrefix = ((iec ? "K" : "k") + "MGTPE").charAt(exponent - 1);
        String binaryPrefix = iec ? "i" : "";
        return unitPrefix + binaryPrefix;
    }
}

