/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Servlets;

public class CacheControlFilter
extends HttpFilter {
    private static final String INIT_PARAM_EXPIRES = "expires";
    private static final long DEFAULT_EXPIRES = 0L;
    private static final long DAYS_PER_WEEK = 7L;
    private static final String ERROR_EXPIRES = "The 'expires' init param must be a number between 0 and 999999999 with optionally the 'w', 'd', 'h', 'm' or 's' suffix. For example: '6w' is 6 weeks. Default suffix is 's' for seconds. For example: '86400' is 86400 seconds. Encountered an invalid value of '%s'.";
    private long expires = 0L;

    @Override
    public void init() throws ServletException {
        if (Servlets.isFacesDevelopment(this.getServletContext())) {
            return;
        }
        String expiresParam = this.getInitParameter(INIT_PARAM_EXPIRES);
        if (expiresParam != null) {
            if (!expiresParam.matches("[0-9]{1,9}[wdhms]?")) {
                throw new ServletException(String.format(ERROR_EXPIRES, expiresParam));
            }
            String[] parts = expiresParam.split("(?=[wdhms])");
            long number = Long.parseLong(parts[0]);
            if (parts.length > 1) {
                String unit = parts[1];
                number = Unit.valueOf(unit.toUpperCase()).toSeconds(number);
            }
            this.expires = number;
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        if (!Servlets.isFacesResourceRequest(request)) {
            Servlets.setCacheHeaders(request, response, this.expires);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static enum Unit {
        W(TimeUnit.DAYS.toSeconds(7L)),
        D(TimeUnit.DAYS.toSeconds(1L)),
        H(TimeUnit.HOURS.toSeconds(1L)),
        M(TimeUnit.MINUTES.toSeconds(1L)),
        S(1L);

        private long seconds;

        private Unit(long seconds) {
            this.seconds = seconds;
        }

        public long toSeconds(long value) {
            return value * this.seconds;
        }
    }
}

