/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.omnifaces.el.functions.Converters;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

public final class CombinedResourceInfo {
    private static final Logger logger = Logger.getLogger(CombinedResourceInfo.class.getName());
    private static final Map<String, CombinedResourceInfo> CACHE = new ConcurrentHashMap<String, CombinedResourceInfo>();
    private static final String LOG_RESOURCE_NOT_FOUND = "CombinedResourceHandler: The resource %s cannot be found and therefore a 404 will be returned for the combined resource ID %s";
    private String id;
    private Set<ResourceIdentifier> resourceIdentifiers;
    private Set<Resource> resources;
    private int contentLength;
    private long lastModified;

    private CombinedResourceInfo(String id, Set<ResourceIdentifier> resourceIdentifiers) {
        this.id = id;
        this.resourceIdentifiers = resourceIdentifiers;
    }

    public static CombinedResourceInfo get(String id) {
        Set<ResourceIdentifier> resourceIdentifiers;
        CombinedResourceInfo info = CACHE.get(id);
        if (info == null && (resourceIdentifiers = CombinedResourceInfo.fromUniqueId(id)) != null) {
            info = CombinedResourceInfo.create(id, resourceIdentifiers);
        }
        return info;
    }

    private static CombinedResourceInfo create(String id, Set<ResourceIdentifier> resourceIdentifiers) {
        CombinedResourceInfo info = new CombinedResourceInfo(id, Collections.unmodifiableSet(resourceIdentifiers));
        CACHE.put(id, info);
        return info;
    }

    private synchronized void loadResources() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!Utils.isEmpty(this.resources) && !FacesLocal.isDevelopment(context)) {
            return;
        }
        long previousLastModified = this.lastModified;
        this.resources = new LinkedHashSet<Resource>();
        this.contentLength = 0;
        this.lastModified = 0L;
        for (ResourceIdentifier resourceIdentifier : this.resourceIdentifiers) {
            Resource resource = FacesLocal.createResource(context, resourceIdentifier.getLibrary(), resourceIdentifier.getName());
            if (resource == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, String.format(LOG_RESOURCE_NOT_FOUND, resourceIdentifier, this.id));
                }
                this.resources.clear();
                return;
            }
            this.resources.add(resource);
            URLConnection connection = Utils.openConnection(context, resource);
            if (connection == null) {
                return;
            }
            this.contentLength += connection.getContentLength();
            long resourceLastModified = connection.getLastModified();
            if (resourceLastModified <= this.lastModified) continue;
            this.lastModified = resourceLastModified;
        }
        if (previousLastModified != 0L && this.lastModified != previousLastModified) {
            String keyPrefix = "omnifaces.combined:" + this.id + ".";
            ResourceIdentifier.clearIntegrity(key -> key.startsWith(keyPrefix));
        }
    }

    public boolean equals(Object other) {
        return other instanceof CombinedResourceInfo && ((CombinedResourceInfo)other).id.equals(this.id);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.id.hashCode();
    }

    public String toString() {
        return String.format("CombinedResourceInfo[%s,%s]", this.id, this.resourceIdentifiers);
    }

    public Set<ResourceIdentifier> getResourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public Set<Resource> getResources() {
        this.loadResources();
        return this.resources;
    }

    public int getContentLength() {
        this.loadResources();
        return this.contentLength;
    }

    public long getLastModified() {
        this.loadResources();
        return this.lastModified;
    }

    private static String toUniqueId(Set<ResourceIdentifier> resourceIdentifiers) {
        return Utils.serializeURLSafe(Converters.joinCollection(resourceIdentifiers, "|"));
    }

    private static Set<ResourceIdentifier> fromUniqueId(String id) {
        String resourcesId;
        try {
            resourcesId = Utils.unserializeURLSafe(id);
        }
        catch (IllegalArgumentException ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; this can only be a hacker attempt, just return null to indicate 404.", ignore);
            return null;
        }
        LinkedHashSet<ResourceIdentifier> resourceIdentifiers = new LinkedHashSet<ResourceIdentifier>();
        for (String resourceIdentifier : resourcesId.split("\\|")) {
            resourceIdentifiers.add(new ResourceIdentifier(resourceIdentifier));
        }
        return resourceIdentifiers;
    }

    public static final class Builder {
        private static final String ERROR_EMPTY_RESOURCES = "There are no resources been added. Use add() method to add them or use isEmpty() to check beforehand.";
        private Set<ResourceIdentifier> resourceIdentifiers = new LinkedHashSet<ResourceIdentifier>();

        public Builder add(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifiers.add(resourceIdentifier);
            return this;
        }

        public boolean isEmpty() {
            return this.resourceIdentifiers.isEmpty();
        }

        public String create() {
            if (this.resourceIdentifiers.isEmpty()) {
                throw new IllegalStateException(ERROR_EMPTY_RESOURCES);
            }
            String id = CombinedResourceInfo.toUniqueId(this.resourceIdentifiers);
            if (!CACHE.containsKey(id)) {
                CombinedResourceInfo.create(id, this.resourceIdentifiers);
            }
            return id;
        }
    }
}

