/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.Bean;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.DynamicResource;
import org.omnifaces.resourcehandler.WebAppManifest;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Json;

public class PWAResourceHandler
extends DefaultResourceHandler {
    private static final Logger logger = Logger.getLogger(PWAResourceHandler.class.getName());
    private static final String WARNING_NO_CACHEABLE_VIEW_IDS = "%s#getCacheableViewIds() returned an empty collection, so no sw.js file will be generated.";
    private static final String WARNING_INVALID_CACHEABLE_VIEW_ID = "Cacheable view ID '%s' does not seem to exist, so it will be skipped for sw.js. Perhaps the %s#getCacheableViewIds() returned a typo?";
    private static final String WARNING_INVALID_OFFLINE_VIEW_ID = "Offline view ID '%s' does not seem to exist, so it will be skipped for sw.js. Perhaps the %s#getOfflineViewId() returned a typo?";
    public static final String MANIFEST_RESOURCE_NAME = "manifest.json";
    public static final String SERVICEWORKER_RESOURCE_NAME = "sw.js";
    public static final String SCRIPT_INIT = "OmniFaces.ServiceWorker.init('%s','%s')";
    private final Bean<WebAppManifest> manifestBean = Beans.resolve(WebAppManifest.class, new Annotation[0]);
    private byte[] manifestContents;
    private byte[] serviceWorkerContents;
    private long lastModified;

    public PWAResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    @Override
    public Resource decorateResource(Resource resource, String resourceName, String libraryName) {
        FacesContext context;
        boolean resourceContentsRequest;
        if (this.manifestBean == null || !"omnifaces".equals(libraryName)) {
            return resource;
        }
        boolean manifestResourceRequest = MANIFEST_RESOURCE_NAME.equals(resourceName);
        boolean serviceWorkerResourceRequest = SERVICEWORKER_RESOURCE_NAME.equals(resourceName);
        if (!manifestResourceRequest && !serviceWorkerResourceRequest) {
            return resource;
        }
        WebAppManifest manifest = Beans.getInstance(this.manifestBean, false);
        if (manifest == null) {
            manifest = Beans.getInstance(this.manifestBean, true);
            this.lastModified = 0L;
        }
        if ((resourceContentsRequest = (context = Faces.getContext()).getApplication().getResourceHandler().isResourceRequest(context)) && this.lastModified == 0L) {
            this.manifestContents = Json.encode(manifest, PWAResourceHandler::camelCaseToSnakeCase).getBytes(StandardCharsets.UTF_8);
            this.serviceWorkerContents = PWAResourceHandler.getServiceWorkerContents(manifest).getBytes(StandardCharsets.UTF_8);
            this.lastModified = System.currentTimeMillis();
        }
        if (manifestResourceRequest) {
            if (!resourceContentsRequest) {
                if (!manifest.getCacheableViewIds().isEmpty()) {
                    Components.addScriptResource("javax.faces", "jsf.js");
                    Components.addScriptResource("omnifaces", "omnifaces.js");
                    Components.addScript(String.format(SCRIPT_INIT, PWAResourceHandler.getServiceWorkerUrl(context), PWAResourceHandler.getServiceWorkerScope(context)));
                } else {
                    logger.warning(String.format(WARNING_NO_CACHEABLE_VIEW_IDS, manifest.getClass().getName()));
                }
            }
            return this.createManifestResource();
        }
        return this.createServiceWorkerResource();
    }

    private DynamicResource createManifestResource() {
        return new DynamicResource(MANIFEST_RESOURCE_NAME, "omnifaces", "application/json"){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(PWAResourceHandler.this.manifestContents);
            }

            @Override
            public long getLastModified() {
                return PWAResourceHandler.this.lastModified;
            }
        };
    }

    private DynamicResource createServiceWorkerResource() {
        return new DynamicResource(SERVICEWORKER_RESOURCE_NAME, "omnifaces", "application/javascript"){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(PWAResourceHandler.this.serviceWorkerContents);
            }

            @Override
            public long getLastModified() {
                return PWAResourceHandler.this.lastModified;
            }

            @Override
            public Map<String, String> getResponseHeaders() {
                Map<String, String> responseHeaders = super.getResponseHeaders();
                responseHeaders.put("Service-Worker-Allowed", PWAResourceHandler.getServiceWorkerScope(Faces.getContext()));
                return responseHeaders;
            }
        };
    }

    private static String camelCaseToSnakeCase(String string) {
        return string.codePoints().collect(StringBuilder::new, (sb, cp) -> {
            if (Character.isUpperCase(cp)) {
                sb.append('_').appendCodePoint(Character.toLowerCase(cp));
            } else {
                sb.appendCodePoint(cp);
            }
        }, (sb1, sb2) -> {}).toString();
    }

    private static String getServiceWorkerContents(WebAppManifest manifest) {
        if (manifest.getCacheableViewIds().isEmpty()) {
            return "";
        }
        try (Scanner scanner = new Scanner(Faces.getResourceAsStream("/omnifaces/sw.js"), StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next().replace("$cacheableResources", Json.encode(PWAResourceHandler.getCacheableResources(manifest))).replace("$offlineResource", Json.encode(PWAResourceHandler.getOfflineResource(manifest)));
            return string;
        }
    }

    private static Collection<String> getCacheableResources(WebAppManifest manifest) {
        FacesContext context = Faces.getContext();
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        LinkedHashSet<String> viewIds = new LinkedHashSet<String>(manifest.getCacheableViewIds());
        LinkedHashSet<String> cacheableResources = new LinkedHashSet<String>();
        cacheableResources.add(manifest.getStartUrl().replaceFirst(Pattern.quote(Faces.getRequestDomainURL()), ""));
        if (manifest.getOfflineViewId() != null) {
            viewIds.add(manifest.getOfflineViewId());
        }
        for (String viewId : viewIds) {
            ViewDeclarationLanguage viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(context, viewId);
            if (!viewDeclarationLanguage.viewExists(context, viewId)) {
                logger.warning(String.format(viewId.equals(manifest.getOfflineViewId()) ? WARNING_INVALID_OFFLINE_VIEW_ID : WARNING_INVALID_CACHEABLE_VIEW_ID, viewId, manifest.getClass().getName()));
                continue;
            }
            cacheableResources.add(viewHandler.getActionURL(context, viewId));
            UIViewRoot view = viewHandler.createView(context, viewId);
            try {
                context.setViewRoot(view);
                viewDeclarationLanguage.buildView(context, view);
                context.getApplication().publishEvent(context, PreRenderViewEvent.class, (Object)view);
            }
            catch (Exception e) {
                throw new FacesException("Cannot build the view " + viewId, (Throwable)e);
            }
            Components.forEachComponent(context).fromRoot((UIComponent)view).ofTypes(UIGraphic.class, UIOutput.class).invoke(component -> {
                String url;
                if (component instanceof UIGraphic && ((UIGraphic)component).getValue() != null) {
                    cacheableResources.add(((UIGraphic)component).getValue().toString());
                } else if (component.getAttributes().get("name") != null && (url = PWAResourceHandler.getResourceUrl(context, (String)component.getAttributes().get("library"), (String)component.getAttributes().get("name"))) != null) {
                    cacheableResources.add(url);
                }
            });
        }
        cacheableResources.add(PWAResourceHandler.getResourceUrl(context, "javax.faces", "jsf.js"));
        cacheableResources.add(PWAResourceHandler.getResourceUrl(context, "omnifaces", "omnifaces.js"));
        return cacheableResources;
    }

    private static String getOfflineResource(WebAppManifest manifest) {
        if (manifest.getOfflineViewId() != null) {
            FacesContext context = Faces.getContext();
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            return viewHandler.getActionURL(context, manifest.getOfflineViewId());
        }
        return null;
    }

    private static String getServiceWorkerUrl(FacesContext context) {
        return context.getExternalContext().encodeResourceURL(FacesLocal.createResource(context, "omnifaces", SERVICEWORKER_RESOURCE_NAME).getRequestPath());
    }

    private static String getServiceWorkerScope(FacesContext context) {
        return FacesLocal.getRequestContextPath(context) + "/";
    }

    private static String getResourceUrl(FacesContext context, String libraryName, String resourceName) {
        Resource resource = FacesLocal.createResource(context, libraryName, resourceName);
        if (resource == null) {
            return null;
        }
        return resource.getRequestPath().replaceAll("([?&])v=.*?([&#]|$)", "$2");
    }
}

