/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

public class ResourceIdentifier {
    private static final Logger logger = Logger.getLogger(ResourceIdentifier.class.getName());
    private static final Map<String, String> INTEGRITIES = new ConcurrentHashMap<String, String>();
    private static final String WARNING_CANNOT_COMPUTE_INTEGRITY = "Cannot compute integrity for %s; defaulting to empty string";
    private String library;
    private String name;

    public ResourceIdentifier(String resourceIdentifier) {
        String[] parts = resourceIdentifier.split(":");
        this.setLibraryAndName(parts.length > 1 ? parts[0] : null, parts[parts.length - 1]);
    }

    public ResourceIdentifier(UIComponent componentResource) {
        Map attributes = componentResource.getAttributes();
        this.setLibraryAndName((String)attributes.get("library"), (String)attributes.get("name"));
    }

    public ResourceIdentifier(String library, String name) {
        this.setLibraryAndName(library, name);
    }

    public ResourceIdentifier(Resource resource) {
        this.setLibraryAndName(resource.getLibraryName(), resource.getResourceName());
    }

    private void setLibraryAndName(String library, String name) {
        this.library = library;
        this.name = name != null ? name.split("[?#;]", 2)[0] : null;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.name;
    }

    public String getIntegrity(FacesContext context) {
        return INTEGRITIES.computeIfAbsent(this.toString(), k -> ResourceIdentifier.computeIntegrity(context, this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)object;
        if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.library == null ? 0 : this.library.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return (this.library != null ? this.library + ":" : "") + this.name;
    }

    private static String computeIntegrity(FacesContext context, ResourceIdentifier id) {
        try {
            byte[] content = Utils.toByteArray(FacesLocal.createResource(context, id).getInputStream());
            byte[] sha384 = MessageDigest.getInstance("SHA-384").digest(content);
            return "sha384-" + Base64.getEncoder().encodeToString(sha384);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format(WARNING_CANNOT_COMPUTE_INTEGRITY, id), e);
            return "";
        }
    }

    static void clearIntegrity(Predicate<String> keyPredicate) {
        INTEGRITIES.keySet().removeIf(keyPredicate::test);
    }
}

