/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import org.omnifaces.context.OmniPartialViewContext;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;

public final class Ajax {
    private static final String ERROR_NO_SCRIPT_RESOURCE = "";
    private static final String ERROR_NO_PARTIAL_RENDERING = "The current request is not an ajax request with partial rendering. Use Components#addScriptXxx() methods instead.";
    private static final String ERROR_ARGUMENTS_LENGTH = "The arguments length must be even. Encountered %d items.";
    private static final String ERROR_ARGUMENT_TYPE = "The argument name must be a String. Encountered type '%s' with value '%s'.";

    private Ajax() {
    }

    public static PartialViewContext getContext() {
        return Faces.getContext().getPartialViewContext();
    }

    public static void update(String ... clientIds) {
        PartialViewContext context = Ajax.getContext();
        Collection renderIds = context.getRenderIds();
        for (String clientId : clientIds) {
            Object currentComponent;
            if (clientId.charAt(0) != '@') {
                renderIds.add(clientId);
                continue;
            }
            if ("@all".equals(clientId)) {
                context.setRenderAll(true);
                continue;
            }
            if ("@form".equals(clientId)) {
                UIForm currentForm = Components.getCurrentForm();
                if (currentForm == null) continue;
                renderIds.add(currentForm.getClientId());
                continue;
            }
            if (!"@this".equals(clientId) || (currentComponent = Components.getCurrentComponent()) == null) continue;
            renderIds.add(currentComponent.getClientId());
        }
    }

    public static void updateAll() {
        Ajax.getContext().setRenderAll(true);
    }

    public static void updateRow(UIData table, int index) {
        if (index < 0 || table.getRowCount() < 1 || index >= table.getRowCount() || table.getChildCount() == 0) {
            return;
        }
        Ajax.updateRowCells(table, index);
    }

    private static void updateRowCells(UIData table, int index) {
        FacesContext context = FacesContext.getCurrentInstance();
        String parentId = table.getParent().getNamingContainer().getClientId(context);
        String tableId = table.getId();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        Collection renderIds = Ajax.getContext().getRenderIds();
        for (UIComponent column : table.getChildren()) {
            if (column instanceof UIColumn) {
                if (!column.isRendered()) continue;
                for (UIComponent cell : column.getChildren()) {
                    if (!cell.isRendered()) continue;
                    renderIds.add(String.format("%s%c%s%c%d%c%s", parentId, Character.valueOf(separator), tableId, Character.valueOf(separator), index, Character.valueOf(separator), cell.getId()));
                }
                continue;
            }
            if (!(column instanceof UIData)) continue;
            Ajax.updateRowCells((UIData)column, renderIds, tableId, index, separator);
        }
    }

    private static void updateRowCells(UIData columns, Collection<String> renderIds, String tableId, int index, char separator) {
        String columnId = columns.getId();
        int columnCount = columns.getRowCount();
        for (UIComponent cell : columns.getChildren()) {
            if (!cell.isRendered()) continue;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                renderIds.add(String.format("%s%c%d%c%s%c%d%c%s", tableId, Character.valueOf(separator), index, Character.valueOf(separator), columnId, Character.valueOf(separator), columnIndex, Character.valueOf(separator), cell.getId()));
            }
        }
    }

    public static void updateColumn(UIData table, int index) {
        int rowCount;
        if (index < 0 || table.getRowCount() < 1 || index > table.getChildCount()) {
            return;
        }
        int n = rowCount = table.getRows() == 0 ? table.getRowCount() : table.getRows();
        if (rowCount == 0) {
            return;
        }
        Ajax.updateColumnCells(table, index, rowCount);
    }

    private static void updateColumnCells(UIData table, int index, int rowCount) {
        FacesContext context = FacesContext.getCurrentInstance();
        String parentId = table.getParent().getNamingContainer().getClientId(context);
        String tableId = table.getId();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        Collection renderIds = Ajax.getContext().getRenderIds();
        UIColumn column = Ajax.findColumn(table, index);
        if (column != null && column.isRendered()) {
            for (UIComponent cell : column.getChildren()) {
                if (!cell.isRendered()) continue;
                String cellId = cell.getId();
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    renderIds.add(String.format("%s%c%s%c%d%c%s", parentId, Character.valueOf(separator), tableId, Character.valueOf(separator), rowIndex, Character.valueOf(separator), cellId));
                }
            }
        }
    }

    private static UIColumn findColumn(UIData table, int index) {
        int columnIndex = 0;
        for (UIComponent column : table.getChildren()) {
            if (!(column instanceof UIColumn) || columnIndex++ != index) continue;
            return (UIColumn)column;
        }
        return null;
    }

    public static void load(String libraryName, String resourceName) {
        Resource resource = Faces.createResource(libraryName, resourceName);
        if (resource == null) {
            throw new IllegalArgumentException(ERROR_NO_SCRIPT_RESOURCE);
        }
        try (Scanner scanner = new Scanner(resource.getInputStream(), StandardCharsets.UTF_8.name());){
            Ajax.oncomplete(scanner.useDelimiter("\\A").next());
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static void oncomplete(String ... scripts) {
        if (!Faces.isAjaxRequestWithPartialRendering()) {
            throw new IllegalStateException(ERROR_NO_PARTIAL_RENDERING);
        }
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (String script : scripts) {
            context.addCallbackScript(script);
        }
    }

    public static void data(String name, Object value) {
        OmniPartialViewContext.getCurrentInstance().addArgument(name, value);
    }

    public static void data(Object ... namesValues) {
        if (namesValues.length % 2 != 0) {
            throw new IllegalArgumentException(String.format(ERROR_ARGUMENTS_LENGTH, namesValues.length));
        }
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (int i = 0; i < namesValues.length; i += 2) {
            if (!(namesValues[i] instanceof String)) {
                String type = namesValues[i] != null ? namesValues[i].getClass().getName() : "null";
                throw new IllegalArgumentException(String.format(ERROR_ARGUMENT_TYPE, type, namesValues[i]));
            }
            context.addArgument((String)namesValues[i], namesValues[i + 1]);
        }
    }

    public static void data(Map<String, Object> data) {
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            context.addArgument(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isExecuted(String clientId) {
        return Ajax.getContext().getExecuteIds().contains(clientId);
    }
}

