/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import javax.faces.component.UIComponent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.eventlistener.CallbackPhaseListener;
import org.omnifaces.eventlistener.DefaultPhaseListener;
import org.omnifaces.eventlistener.DefaultSystemEventListener;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Faces;

public final class Events {
    private static final String ERROR_UNSUBSCRIBE_TOO_LATE = "The render response phase is too late to unsubscribe the view event listener. Do it in an earlier phase.";

    private Events() {
    }

    public static void subscribeToApplicationEvent(Class<? extends SystemEvent> type, SystemEventListener listener) {
        Faces.getApplication().subscribeToEvent(type, listener);
    }

    public static void subscribeToApplicationEvent(Class<? extends SystemEvent> type, Callback.SerializableVoid callback) {
        Events.subscribeToApplicationEvent(type, Events.createSystemEventListener(Events.wrap(callback)));
    }

    public static void subscribeToApplicationEvent(Class<? extends SystemEvent> type, Callback.SerializableWithArgument<SystemEvent> callback) {
        Events.subscribeToApplicationEvent(type, Events.createSystemEventListener(callback));
    }

    public static void subscribeToViewEvent(Class<? extends SystemEvent> type, SystemEventListener listener) {
        Faces.getViewRoot().subscribeToViewEvent(type, listener);
    }

    public static void subscribeToViewEvent(Class<? extends SystemEvent> type, Callback.SerializableVoid callback) {
        Events.subscribeToViewEvent(type, Events.createSystemEventListener(Events.wrap(callback)));
    }

    public static void subscribeToViewEvent(Class<? extends SystemEvent> type, Callback.SerializableWithArgument<SystemEvent> callback) {
        Events.subscribeToViewEvent(type, Events.createSystemEventListener(callback));
    }

    public static void addViewPhaseListener(PhaseListener listener) {
        Faces.getViewRoot().addPhaseListener(listener);
    }

    public static void subscribeToViewBeforePhase(PhaseId phaseId, Callback.Void callback) {
        Events.addViewPhaseListener(Events.createBeforePhaseListener(phaseId, Events.wrap(callback)));
    }

    public static void subscribeToViewBeforePhase(PhaseId phaseId, Callback.WithArgument<PhaseEvent> callback) {
        Events.addViewPhaseListener(Events.createBeforePhaseListener(phaseId, callback));
    }

    public static void subscribeToViewAfterPhase(PhaseId phaseId, Callback.Void callback) {
        Events.addViewPhaseListener(Events.createAfterPhaseListener(phaseId, Events.wrap(callback)));
    }

    public static void subscribeToViewAfterPhase(PhaseId phaseId, Callback.WithArgument<PhaseEvent> callback) {
        Events.addViewPhaseListener(Events.createAfterPhaseListener(phaseId, callback));
    }

    public static void subscribeToRequestComponentEvent(final UIComponent component, final Class<? extends ComponentSystemEvent> type, final Callback.WithArgument<ComponentSystemEvent> callback) {
        component.subscribeToEvent(type, new ComponentSystemEventListener(){

            public void processEvent(ComponentSystemEvent event) {
                Events.unsubscribeFromComponentEvent(component, type, this);
                callback.invoke(event);
            }
        });
    }

    public static void addRequestPhaseListener(PhaseListener listener) {
        CallbackPhaseListener.add(listener);
    }

    public static void subscribeToRequestBeforePhase(PhaseId phaseId, Callback.Void callback) {
        Events.addRequestPhaseListener(Events.createBeforePhaseListener(phaseId, Events.wrap(callback)));
    }

    public static void subscribeToRequestBeforePhase(PhaseId phaseId, Callback.WithArgument<PhaseEvent> callback) {
        Events.addRequestPhaseListener(Events.createBeforePhaseListener(phaseId, callback));
    }

    public static void subscribeToRequestAfterPhase(PhaseId phaseId, Callback.Void callback) {
        Events.addRequestPhaseListener(Events.createAfterPhaseListener(phaseId, Events.wrap(callback)));
    }

    public static void subscribeToRequestAfterPhase(PhaseId phaseId, Callback.WithArgument<PhaseEvent> callback) {
        Events.addRequestPhaseListener(Events.createAfterPhaseListener(phaseId, callback));
    }

    public static void unsubscribeFromComponentEvent(UIComponent component, Class<? extends SystemEvent> event, ComponentSystemEventListener listener) {
        PhaseId currentPhaseId = Faces.getCurrentPhaseId();
        if (currentPhaseId == PhaseId.RENDER_RESPONSE) {
            throw new IllegalStateException(ERROR_UNSUBSCRIBE_TOO_LATE);
        }
        Events.subscribeToRequestAfterPhase(currentPhaseId, () -> component.unsubscribeFromEvent(event, listener));
    }

    private static <A> Callback.WithArgument<A> wrap(Callback.Void callback) {
        return argument -> callback.invoke();
    }

    private static <A> Callback.SerializableWithArgument<A> wrap(Callback.SerializableVoid callback) {
        return argument -> callback.invoke();
    }

    private static SystemEventListener createSystemEventListener(final Callback.SerializableWithArgument<SystemEvent> callback) {
        return new DefaultSystemEventListener(){

            @Override
            public void processEvent(SystemEvent event) {
                callback.invoke(event);
            }
        };
    }

    private static PhaseListener createBeforePhaseListener(PhaseId phaseId, final Callback.WithArgument<PhaseEvent> callback) {
        return new DefaultPhaseListener(phaseId){
            private static final long serialVersionUID = 1L;

            @Override
            public void beforePhase(PhaseEvent event) {
                callback.invoke(event);
            }
        };
    }

    private static PhaseListener createAfterPhaseListener(PhaseId phaseId, final Callback.WithArgument<PhaseEvent> callback) {
        return new DefaultPhaseListener(phaseId){
            private static final long serialVersionUID = 1L;

            @Override
            public void afterPhase(PhaseEvent event) {
                callback.invoke(event);
            }
        };
    }
}

