/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.FaceletContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.component.input.HashParam;
import org.omnifaces.component.input.ScriptParam;
import org.omnifaces.config.FacesConfigXml;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public final class FacesLocal {
    private static final Logger logger = Logger.getLogger(FacesLocal.class.getName());
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final int DEFAULT_SENDFILE_BUFFER_SIZE = 10240;
    private static final String ERROR_NO_VIEW = "There is no view.";
    private static String faceletsSuffix;

    private FacesLocal() {
    }

    private static String getFaceletsSuffix(FacesContext context) {
        if (faceletsSuffix == null) {
            faceletsSuffix = Utils.coalesce(FacesLocal.getInitParameter(context, "javax.faces.FACELETS_SUFFIX"), ".xhtml");
        }
        return faceletsSuffix;
    }

    public static Package getPackage(FacesContext context) {
        if (context != null) {
            while (context instanceof FacesWrapper) {
                context = (FacesContext)((FacesWrapper)context).getWrapped();
            }
            return context.getClass().getPackage();
        }
        return FacesContext.class.getPackage();
    }

    public static String getImplInfo(FacesContext context) {
        Package facesPackage = FacesLocal.getPackage(context);
        return facesPackage.getImplementationTitle() + " " + facesPackage.getImplementationVersion();
    }

    public static String getServerInfo(FacesContext context) {
        return FacesLocal.getServletContext(context).getServerInfo();
    }

    public static ProjectStage getProjectStage(FacesContext context) {
        return context.getApplication().getProjectStage();
    }

    public static boolean isDevelopment(FacesContext context) {
        return FacesLocal.getProjectStage(context) == ProjectStage.Development;
    }

    public static boolean isSystemTest(FacesContext context) {
        return FacesLocal.getProjectStage(context) == ProjectStage.SystemTest;
    }

    public static boolean isProduction(FacesContext context) {
        return FacesLocal.getProjectStage(context) == ProjectStage.Production;
    }

    public static String getMapping(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.getRequestPathInfo() == null) {
            String path = externalContext.getRequestServletPath();
            int suffixPos = path.lastIndexOf(46);
            return suffixPos > -1 ? path.substring(suffixPos) : FacesLocal.getFaceletsSuffix(context);
        }
        return externalContext.getRequestServletPath();
    }

    public static boolean isPrefixMapping(FacesContext context) {
        return Faces.isPrefixMapping(FacesLocal.getMapping(context));
    }

    public static <T> T evaluateExpressionGet(FacesContext context, String expression) {
        if (Utils.isEmpty(expression)) {
            return null;
        }
        return (T)context.getApplication().evaluateExpressionGet(context, expression, Object.class);
    }

    public static void evaluateExpressionSet(FacesContext context, String expression, Object value) {
        ELContext elContext = context.getELContext();
        ValueExpression valueExpression = context.getApplication().getExpressionFactory().createValueExpression(elContext, expression, Object.class);
        valueExpression.setValue(elContext, value);
    }

    public static <T> T resolveExpressionGet(FacesContext context, Object base, String property) {
        ELResolver elResolver = context.getApplication().getELResolver();
        return (T)elResolver.getValue(context.getELContext(), base, (Object)property);
    }

    public static void resolveExpressionSet(FacesContext context, Object base, String property, Object value) {
        ELResolver elResolver = context.getApplication().getELResolver();
        elResolver.setValue(context.getELContext(), base, (Object)property, value);
    }

    public static <T> T getContextAttribute(FacesContext context, String name) {
        return (T)context.getAttributes().get(name);
    }

    public static <T> T getContextAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getContextAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setContextAttribute(context, name, value);
        }
        return value;
    }

    public static void setContextAttribute(FacesContext context, String name, Object value) {
        context.getAttributes().put(name, value);
    }

    public static <T> Converter<T> createConverter(FacesContext context, Object identifier) {
        if (identifier instanceof String) {
            return FacesLocal.createConverter(context, (String)identifier);
        }
        if (identifier instanceof Class) {
            return FacesLocal.createConverter(context, (Class)identifier);
        }
        if (identifier instanceof Converter) {
            return (Converter)identifier;
        }
        return null;
    }

    public static <T> Converter<T> createConverter(FacesContext context, String identifier) {
        Converter<T> converter = context.getApplication().createConverter(identifier);
        if (converter == null) {
            converter = FacesLocal.createConverter(context, Reflection.toClassOrNull(identifier));
        }
        return converter;
    }

    public static <T> Converter<T> createConverter(FacesContext context, Class<?> identifier) {
        if (Converter.class.isAssignableFrom(identifier)) {
            FacesConverter annotation = identifier.getAnnotation(FacesConverter.class);
            if (annotation != null) {
                return (Converter)Beans.getReference(identifier, new Annotation[]{annotation});
            }
            return (Converter)Reflection.instance(identifier);
        }
        return context.getApplication().createConverter(identifier);
    }

    public static <T> Validator<T> createValidator(FacesContext context, Object identifier) {
        if (identifier instanceof String) {
            return FacesLocal.createValidator(context, (String)identifier);
        }
        if (identifier instanceof Class) {
            return FacesLocal.createValidator(context, (Class)identifier);
        }
        if (identifier instanceof Validator) {
            return (Validator)identifier;
        }
        return null;
    }

    public static <T> Validator<T> createValidator(FacesContext context, String identifier) {
        Validator<T> validator = context.getApplication().createValidator(identifier);
        if (validator == null) {
            validator = FacesLocal.createValidator(context, Reflection.toClassOrNull(identifier));
        }
        return validator;
    }

    public static <T> Validator<T> createValidator(FacesContext context, Class<?> identifier) {
        if (Validator.class.isAssignableFrom(identifier)) {
            FacesValidator annotation = identifier.getAnnotation(FacesValidator.class);
            if (annotation != null) {
                return (Validator)Beans.getReference(identifier, new Annotation[]{annotation});
            }
            return (Validator)Reflection.instance(identifier);
        }
        return null;
    }

    public static Resource createResource(FacesContext context, String resourceName) {
        return context.getApplication().getResourceHandler().createResource(resourceName);
    }

    public static Resource createResource(FacesContext context, String libraryName, String resourceName) {
        return context.getApplication().getResourceHandler().createResource(resourceName, libraryName);
    }

    public static Resource createResource(FacesContext context, ResourceIdentifier resourceIdentifier) {
        return context.getApplication().getResourceHandler().createResource(resourceIdentifier.getName(), resourceIdentifier.getLibrary());
    }

    public static Lifecycle getLifecycle(FacesContext context) {
        return Servlets.getFacesLifecycle(FacesLocal.getServletContext(context));
    }

    public static void setViewRoot(FacesContext context, String viewId) {
        context.setViewRoot(context.getApplication().getViewHandler().createView(context, viewId));
    }

    public static String getViewId(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot != null ? viewRoot.getViewId() : null;
    }

    public static String getViewIdWithParameters(FacesContext context) {
        String viewId = Utils.coalesce(FacesLocal.getViewId(context), "");
        String viewParameters = Servlets.toQueryString(FacesLocal.getViewParameterMap(context));
        String hashParameters = FacesLocal.getHashQueryString(context);
        return (viewParameters == null ? viewId : viewId + "?" + viewParameters) + (hashParameters == null ? "" : "#" + hashParameters);
    }

    public static String getViewName(FacesContext context) {
        String viewId = FacesLocal.getViewId(context);
        return viewId != null ? viewId.substring(viewId.lastIndexOf(47) + 1).split("\\.")[0] : null;
    }

    public static ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context) {
        return context.getApplication().getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId());
    }

    public static RenderKit getRenderKit(FacesContext context) {
        String renderKitId = null;
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            renderKitId = view.getRenderKitId();
        }
        if (renderKitId == null) {
            Application application = context.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            if (viewHandler != null) {
                renderKitId = viewHandler.calculateRenderKitId(context);
            }
            if (renderKitId == null && (renderKitId = application.getDefaultRenderKitId()) == null) {
                renderKitId = "HTML_BASIC";
            }
        }
        return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit(context, renderKitId);
    }

    public static String normalizeViewId(FacesContext context, String path) {
        String mapping = FacesLocal.getMapping(context);
        if (Faces.isPrefixMapping(mapping)) {
            if (path.startsWith(mapping)) {
                return path.substring(mapping.length());
            }
        } else if (path.endsWith(mapping)) {
            return path.substring(0, path.lastIndexOf(46)) + Utils.coalesce(FacesLocal.getInitParameter(context, "javax.faces.FACELETS_SUFFIX"), ".xhtml");
        }
        return path;
    }

    public static Collection<UIViewParameter> getViewParameters(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot != null ? ViewMetadata.getViewParameters((UIViewRoot)viewRoot) : Collections.emptyList();
    }

    public static Map<String, List<String>> getViewParameterMap(FacesContext context) {
        Collection<UIViewParameter> viewParameters = FacesLocal.getViewParameters(context);
        if (viewParameters.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(0);
        }
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(viewParameters.size());
        for (UIViewParameter viewParameter : viewParameters) {
            String value = viewParameter.getStringValue(context);
            if (value == null) continue;
            parameterMap.put(viewParameter.getName(), Arrays.asList(value));
        }
        return parameterMap;
    }

    public static Collection<HashParam> getHashParameters(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot != null ? Components.findComponentsInChildren(viewRoot.getFacet("javax_faces_metadata"), HashParam.class) : Collections.emptyList();
    }

    public static Map<String, List<String>> getHashParameterMap(FacesContext context) {
        Collection<HashParam> hashParameters = FacesLocal.getHashParameters(context);
        if (hashParameters.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(0);
        }
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(hashParameters.size());
        for (HashParam hashParameter : hashParameters) {
            String value;
            if (Utils.isEmpty(hashParameter.getName()) || Utils.isEmpty(value = hashParameter.getRenderedValue(context))) continue;
            parameterMap.put(hashParameter.getName(), Arrays.asList(value));
        }
        return parameterMap;
    }

    public static String getHashQueryString(FacesContext context) {
        return Servlets.toQueryString(FacesLocal.getHashParameterMap(context));
    }

    public static Collection<ScriptParam> getScriptParameters(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot != null ? Components.findComponentsInChildren(viewRoot.getFacet("javax_faces_metadata"), ScriptParam.class) : Collections.emptyList();
    }

    public static Map<String, Object> getMetadataAttributes(FacesContext context, String viewId) {
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
        ViewMetadata metadata = vdl.getViewMetadata(context, viewId);
        return metadata != null ? metadata.createMetadataView(context).getAttributes() : Collections.emptyMap();
    }

    public static Map<String, Object> getMetadataAttributes(FacesContext context) {
        return context.getViewRoot().getAttributes();
    }

    public static <T> T getMetadataAttribute(FacesContext context, String viewId, String name) {
        return (T)FacesLocal.getMetadataAttributes(context, viewId).get(name);
    }

    public static <T> T getMetadataAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getMetadataAttributes(context).get(name);
    }

    public static Locale getLocale(FacesContext context) {
        Locale locale = null;
        if (context != null) {
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot != null) {
                locale = viewRoot.getLocale();
            }
            if (locale == null) {
                Locale clientLocale = context.getExternalContext().getRequestLocale();
                if (FacesLocal.getSupportedLocales(context).contains(clientLocale)) {
                    locale = clientLocale;
                }
            }
            if (locale == null) {
                locale = context.getApplication().getDefaultLocale();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static Locale getDefaultLocale(FacesContext context) {
        return context.getApplication().getDefaultLocale();
    }

    public static List<Locale> getSupportedLocales(FacesContext context) {
        Application application = context.getApplication();
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        Locale defaultLocale = application.getDefaultLocale();
        if (defaultLocale != null) {
            supportedLocales.add(defaultLocale);
        }
        Iterator iter = application.getSupportedLocales();
        while (iter.hasNext()) {
            Locale supportedLocale = (Locale)iter.next();
            if (supportedLocale.equals(defaultLocale)) continue;
            supportedLocales.add(supportedLocale);
        }
        return supportedLocales;
    }

    public static void setLocale(FacesContext context, Locale locale) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        viewRoot.setLocale(locale);
    }

    public static ResourceBundle getMessageBundle(FacesContext context) {
        String messageBundle = context.getApplication().getMessageBundle();
        if (messageBundle == null) {
            return null;
        }
        return ResourceBundle.getBundle(messageBundle, FacesLocal.getLocale(context));
    }

    public static ResourceBundle getResourceBundle(FacesContext context, String var) {
        return context.getApplication().getResourceBundle(context, var);
    }

    public static Map<String, ResourceBundle> getResourceBundles(FacesContext context) {
        Map<String, String> resourceBundles = FacesConfigXml.instance().getResourceBundles();
        HashMap<String, ResourceBundle> map = new HashMap<String, ResourceBundle>(resourceBundles.size());
        for (String var : resourceBundles.keySet()) {
            map.put(var, FacesLocal.getResourceBundle(context, var));
        }
        return map;
    }

    public static String getBundleString(FacesContext context, String key) {
        for (ResourceBundle bundle : FacesLocal.getResourceBundles(context).values()) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; there is a fallback anyway.", ignore);
            }
        }
        return "???" + key + "???";
    }

    public static void navigate(FacesContext context, String outcome) {
        context.getApplication().getNavigationHandler().handleNavigation(context, null, outcome);
    }

    public static String getBookmarkableURL(FacesContext context, Map<String, List<String>> params, boolean includeViewParams) {
        String viewId = FacesLocal.getViewId(context);
        if (viewId == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        return FacesLocal.getBookmarkableURL(context, viewId, params, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> params, boolean includeViewParams) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (params != null) {
            for (Map.Entry<String, List<String>> param : params.entrySet()) {
                for (String value : param.getValue()) {
                    Servlets.addParamToMapIfNecessary(map, param.getKey(), value);
                }
            }
        }
        return context.getApplication().getViewHandler().getBookmarkableURL(context, viewId, map, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context, Collection<? extends ParamHolder<?>> params, boolean includeViewParams) {
        String viewId = FacesLocal.getViewId(context);
        if (viewId == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        return FacesLocal.getBookmarkableURL(context, viewId, params, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context, String viewId, Collection<? extends ParamHolder<?>> params, boolean includeViewParams) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (params != null) {
            for (ParamHolder<?> param : params) {
                Servlets.addParamToMapIfNecessary(map, param.getName(), param.getValue());
            }
        }
        return context.getApplication().getViewHandler().getBookmarkableURL(context, viewId, map, includeViewParams);
    }

    public static FaceletContext getFaceletContext(FacesContext context) {
        FaceletContext faceletContext = (FaceletContext)FacesLocal.getContextAttribute(context, FaceletContext.FACELET_CONTEXT_KEY);
        if (faceletContext != null) {
            return faceletContext;
        }
        throw new IllegalStateException(ERROR_NO_VIEW);
    }

    public static <T> T getFaceletAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getFaceletContext(context).getAttribute(name);
    }

    public static void setFaceletAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getFaceletContext(context).setAttribute(name, value);
    }

    public static HttpServletRequest getRequest(FacesContext context) {
        return (HttpServletRequest)context.getExternalContext().getRequest();
    }

    public static boolean isAjaxRequest(FacesContext context) {
        return context.getPartialViewContext().isAjaxRequest();
    }

    public static boolean isAjaxRequestWithPartialRendering(FacesContext context) {
        PartialViewContext pvc = context.getPartialViewContext();
        return pvc.isAjaxRequest() && !pvc.isRenderAll();
    }

    public static boolean isPostback(FacesContext context) {
        return "POST".equalsIgnoreCase(FacesLocal.getRequest(context).getMethod()) && context.isPostback();
    }

    public static Map<String, String> getRequestParameterMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    public static Map<String, List<String>> getMutableRequestParameterMap(FacesContext context) {
        return Servlets.getMutableRequestParameterMap(FacesLocal.getRequest(context));
    }

    public static String getRequestParameter(FacesContext context, String name) {
        return FacesLocal.getRequestParameterMap(context).get(name);
    }

    public static <T> T getRequestParameter(FacesContext context, String name, Class<T> type) {
        return (T)FacesLocal.getRequestParameter(context, name, (String value) -> Optional.ofNullable(FacesLocal.createConverter(context, type)).map(c -> c.getAsObject(context, (UIComponent)context.getViewRoot(), value)).orElse(value));
    }

    public static <T> T getRequestParameter(FacesContext context, String name, Function<String, T> converter) {
        return (T)FacesLocal.getRequestParameter(context, name, converter, () -> null);
    }

    public static <T> T getRequestParameter(FacesContext context, String name, Function<String, T> converter, Supplier<T> defaultValue) {
        return Optional.ofNullable(FacesLocal.getRequestParameter(context, name)).filter(value -> !Utils.isEmpty(value)).map(converter).orElseGet(defaultValue);
    }

    public static Map<String, String[]> getRequestParameterValuesMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterValuesMap();
    }

    public static String[] getRequestParameterValues(FacesContext context, String name) {
        return FacesLocal.getRequestParameterValuesMap(context).get(name);
    }

    public static <T> T[] getRequestParameterValues(FacesContext context, String name, Class<T> type) {
        String[] values = FacesLocal.getRequestParameterValues(context, name);
        if (values == null) {
            return null;
        }
        Converter<T> converter = FacesLocal.createConverter(context, type);
        if (converter == null) {
            return values;
        }
        Object convertedValues = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedValues, i, converter.getAsObject(context, (UIComponent)context.getViewRoot(), values[i]));
        }
        return (Object[])convertedValues;
    }

    public static Collection<Part> getRequestParts(FacesContext context) {
        try {
            return FacesLocal.getRequest(context).getParts();
        }
        catch (IOException | ServletException e) {
            throw new FacesException(e);
        }
    }

    public static Part getRequestPart(FacesContext context, String name) {
        try {
            return FacesLocal.getRequest(context).getPart(name);
        }
        catch (IOException | ServletException e) {
            throw new FacesException(e);
        }
    }

    public static Collection<Part> getRequestParts(FacesContext context, String name) {
        try {
            ArrayList<Part> parts = new ArrayList<Part>();
            for (Part part : FacesLocal.getRequest(context).getParts()) {
                if (!name.equals(part.getName())) continue;
                parts.add(part);
            }
            return Collections.unmodifiableList(parts);
        }
        catch (IOException | ServletException e) {
            throw new FacesException(e);
        }
    }

    public static Map<String, String> getRequestHeaderMap(FacesContext context) {
        return context.getExternalContext().getRequestHeaderMap();
    }

    public static Map<String, List<String>> getMutableRequestHeaderMap(FacesContext context) {
        return Servlets.getMutableRequestHeaderMap(FacesLocal.getRequest(context));
    }

    public static String getRequestHeader(FacesContext context, String name) {
        return FacesLocal.getRequestHeaderMap(context).get(name);
    }

    public static Map<String, String[]> getRequestHeaderValuesMap(FacesContext context) {
        return context.getExternalContext().getRequestHeaderValuesMap();
    }

    public static String[] getRequestHeaderValues(FacesContext context, String name) {
        return FacesLocal.getRequestHeaderValuesMap(context).get(name);
    }

    public static String getRequestContextPath(FacesContext context) {
        return context.getExternalContext().getRequestContextPath();
    }

    public static String getRequestServletPath(FacesContext context) {
        return context.getExternalContext().getRequestServletPath();
    }

    public static String getRequestPathInfo(FacesContext context) {
        return Servlets.getRequestPathInfo(FacesLocal.getRequest(context));
    }

    public static String getRequestHostname(FacesContext context) {
        return Servlets.getRequestHostname(FacesLocal.getRequest(context));
    }

    public static String getRequestBaseURL(FacesContext context) {
        return Servlets.getRequestBaseURL(FacesLocal.getRequest(context));
    }

    public static String getRequestDomainURL(FacesContext context) {
        return Servlets.getRequestDomainURL(FacesLocal.getRequest(context));
    }

    public static String getRequestURL(FacesContext context) {
        return Servlets.getRequestURL(FacesLocal.getRequest(context));
    }

    public static String getRequestURI(FacesContext context) {
        return Servlets.getRequestURI(FacesLocal.getRequest(context));
    }

    public static String getRequestQueryString(FacesContext context) {
        return Servlets.getRequestQueryString(FacesLocal.getRequest(context));
    }

    public static Map<String, List<String>> getRequestQueryStringMap(FacesContext context) {
        return Servlets.getRequestQueryStringMap(FacesLocal.getRequest(context));
    }

    public static String getRequestURLWithQueryString(FacesContext context) {
        return Servlets.getRequestURLWithQueryString(FacesLocal.getRequest(context));
    }

    public static String getRequestURIWithQueryString(FacesContext context) {
        return Servlets.getRequestURIWithQueryString(FacesLocal.getRequest(context));
    }

    public static String getRemoteAddr(FacesContext context) {
        return Servlets.getRemoteAddr(FacesLocal.getRequest(context));
    }

    public static String getUserAgent(FacesContext context) {
        return Servlets.getUserAgent(FacesLocal.getRequest(context));
    }

    public static String getReferrer(FacesContext context) {
        return Servlets.getReferrer(FacesLocal.getRequest(context));
    }

    public static boolean isRequestSecure(FacesContext context) {
        return Servlets.isSecure(FacesLocal.getRequest(context));
    }

    public static HttpServletResponse getResponse(FacesContext context) {
        return (HttpServletResponse)context.getExternalContext().getResponse();
    }

    public static int getResponseBufferSize(FacesContext context) {
        return context.getExternalContext().getResponseBufferSize();
    }

    public static String getResponseCharacterEncoding(FacesContext context) {
        return context.getExternalContext().getResponseCharacterEncoding();
    }

    public static void setResponseStatus(FacesContext context, int status) {
        context.getExternalContext().setResponseStatus(status);
    }

    public static void redirect(FacesContext context, String url, Object ... paramValues) {
        ExternalContext externalContext = context.getExternalContext();
        externalContext.getFlash().setRedirect(true);
        externalContext.getFlash().keep("org.omnifaces.view_expired");
        try {
            externalContext.redirect(Servlets.prepareRedirectURL(FacesLocal.getRequest(context), url, paramValues));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void redirectPermanent(FacesContext context, String url, Object ... paramValues) {
        context.getExternalContext().getFlash().setRedirect(true);
        Servlets.redirectPermanent(FacesLocal.getResponse(context), Servlets.prepareRedirectURL(FacesLocal.getRequest(context), url, paramValues));
        context.responseComplete();
    }

    public static void refresh(FacesContext context) {
        FacesLocal.redirect(context, FacesLocal.getRequestURI(context), new Object[0]);
    }

    public static void refreshWithQueryString(FacesContext context) {
        FacesLocal.redirect(context, FacesLocal.getRequestURIWithQueryString(context), new Object[0]);
    }

    public static void responseSendError(FacesContext context, int status, String message) {
        try {
            context.getExternalContext().responseSendError(status, message);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        context.responseComplete();
        if (!Faces.hasContext()) {
            Faces.setContext(context);
        }
    }

    public static void addResponseHeader(FacesContext context, String name, String value) {
        context.getExternalContext().addResponseHeader(name, value);
    }

    public static boolean isResponseCommitted(FacesContext context) {
        return context.getExternalContext().isResponseCommitted();
    }

    public static void responseReset(FacesContext context) {
        context.getExternalContext().responseReset();
    }

    public static boolean isRenderResponse(FacesContext context) {
        return context.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE;
    }

    public static void login(FacesContext context, String username, String password) throws ServletException {
        FacesLocal.getRequest(context).login(username, password);
    }

    public static boolean authenticate(FacesContext context) throws ServletException {
        try {
            return FacesLocal.getRequest(context).authenticate(FacesLocal.getResponse(context));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void logout(FacesContext context) throws ServletException {
        FacesLocal.getRequest(context).logout();
    }

    public static String getRemoteUser(FacesContext context) {
        return context.getExternalContext().getRemoteUser();
    }

    public static boolean isUserInRole(FacesContext context, String role) {
        return context.getExternalContext().isUserInRole(role);
    }

    public static String getRequestCookie(FacesContext context, String name) {
        Cookie cookie = (Cookie)context.getExternalContext().getRequestCookieMap().get(name);
        return cookie != null ? Utils.decodeURL(cookie.getValue()) : null;
    }

    public static void addResponseCookie(FacesContext context, String name, String value, int maxAge) {
        FacesLocal.addResponseCookie(context, name, value, null, null, maxAge);
    }

    public static void addResponseCookie(FacesContext context, String name, String value, String path, int maxAge) {
        FacesLocal.addResponseCookie(context, name, value, null, path, maxAge, true);
    }

    public static void addResponseCookie(FacesContext context, String name, String value, String domain, String path, int maxAge) {
        FacesLocal.addResponseCookie(context, name, value, domain, path, maxAge, true);
    }

    public static void addResponseCookie(FacesContext context, String name, String value, String domain, String path, int maxAge, boolean httpOnly) {
        ExternalContext externalContext = context.getExternalContext();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!"localhost".equals(domain)) {
            properties.put("domain", domain == null ? FacesLocal.getRequestHostname(context) : domain);
        }
        if (path != null) {
            properties.put("path", path);
        }
        properties.put("maxAge", maxAge);
        properties.put("httpOnly", httpOnly);
        properties.put("secure", Servlets.isSecure((HttpServletRequest)externalContext.getRequest()));
        externalContext.addResponseCookie(name, Utils.encodeURL(value), properties);
    }

    public static void removeResponseCookie(FacesContext context, String name, String path) {
        FacesLocal.addResponseCookie(context, name, null, path, 0);
    }

    public static HttpSession getSession(FacesContext context) {
        return FacesLocal.getSession(context, true);
    }

    public static HttpSession getSession(FacesContext context, boolean create) {
        return (HttpSession)context.getExternalContext().getSession(create);
    }

    public static String getSessionId(FacesContext context) {
        HttpSession session = FacesLocal.getSession(context, false);
        return session != null ? session.getId() : null;
    }

    public static void invalidateSession(FacesContext context) {
        context.getExternalContext().invalidateSession();
    }

    public static boolean hasSession(FacesContext context) {
        return FacesLocal.getSession(context, false) != null;
    }

    public static boolean isSessionNew(FacesContext context) {
        HttpSession session = FacesLocal.getSession(context, false);
        return session != null && session.isNew();
    }

    public static boolean isRequestedSessionExpired(FacesContext context) {
        HttpServletRequest request = FacesLocal.getRequest(context);
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }

    public static long getSessionCreationTime(FacesContext context) {
        return FacesLocal.getSession(context).getCreationTime();
    }

    public static long getSessionLastAccessedTime(FacesContext context) {
        return FacesLocal.getSession(context).getLastAccessedTime();
    }

    public static int getSessionMaxInactiveInterval(FacesContext context) {
        return FacesLocal.getSession(context).getMaxInactiveInterval();
    }

    public static void setSessionMaxInactiveInterval(FacesContext context, int seconds) {
        FacesLocal.getSession(context).setMaxInactiveInterval(seconds);
    }

    public static boolean hasSessionTimedOut(FacesContext context) {
        HttpServletRequest request = FacesLocal.getRequest(context);
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }

    public static ServletContext getServletContext(FacesContext context) {
        return (ServletContext)context.getExternalContext().getContext();
    }

    public static Map<String, String> getInitParameterMap(FacesContext context) {
        return context.getExternalContext().getInitParameterMap();
    }

    public static String getInitParameter(FacesContext context, String name) {
        return context.getExternalContext().getInitParameter(name);
    }

    public static String getInitParameterOrDefault(FacesContext context, String name, String defaultValue) {
        return context.getExternalContext().getInitParameterMap().getOrDefault(name, defaultValue);
    }

    public static String getMimeType(FacesContext context, String name) {
        String mimeType = context.getExternalContext().getMimeType(name);
        if (mimeType == null) {
            mimeType = DEFAULT_MIME_TYPE;
        }
        return mimeType;
    }

    public static URL getResource(FacesContext context, String path) throws MalformedURLException {
        return context.getExternalContext().getResource(path);
    }

    public static InputStream getResourceAsStream(FacesContext context, String path) {
        return context.getExternalContext().getResourceAsStream(path);
    }

    public static Set<String> getResourcePaths(FacesContext context, String path) {
        return context.getExternalContext().getResourcePaths(path);
    }

    public static String getRealPath(FacesContext context, String webContentPath) {
        return context.getExternalContext().getRealPath(webContentPath);
    }

    public static Map<String, Object> getRequestMap(FacesContext context) {
        return context.getExternalContext().getRequestMap();
    }

    public static <T> T getRequestAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getRequestMap(context).get(name);
    }

    public static <T> T getRequestAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getRequestAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setRequestAttribute(context, name, value);
        }
        return value;
    }

    public static void setRequestAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getRequestMap(context).put(name, value);
    }

    public static <T> T removeRequestAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getRequestMap(context).remove(name);
    }

    public static Flash getFlash(FacesContext context) {
        return context.getExternalContext().getFlash();
    }

    public static <T> T getFlashAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getFlash(context).get((Object)name);
    }

    public static <T> T getFlashAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getFlashAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setFlashAttribute(context, name, value);
        }
        return value;
    }

    public static void setFlashAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getFlash(context).put((Object)name, value);
    }

    public static <T> T removeFlashAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getFlash(context).remove((Object)name);
    }

    public static Map<String, Object> getViewMap(FacesContext context) {
        return context.getViewRoot().getViewMap();
    }

    public static <T> T getViewAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getViewMap(context).get(name);
    }

    public static <T> T getViewAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getViewAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setViewAttribute(context, name, value);
        }
        return value;
    }

    public static void setViewAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getViewMap(context).put(name, value);
    }

    public static <T> T removeViewAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getViewMap(context).remove(name);
    }

    public static Map<String, Object> getSessionMap(FacesContext context) {
        return context.getExternalContext().getSessionMap();
    }

    public static <T> T getSessionAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getSessionMap(context).get(name);
    }

    public static <T> T getSessionAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getSessionAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setSessionAttribute(context, name, value);
        }
        return value;
    }

    public static void setSessionAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getSessionMap(context).put(name, value);
    }

    public static <T> T removeSessionAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getSessionMap(context).remove(name);
    }

    public static Map<String, Object> getApplicationMap(FacesContext context) {
        return context.getExternalContext().getApplicationMap();
    }

    public static <T> T getApplicationAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getApplicationMap(context).get(name);
    }

    public static <T> T getApplicationAttribute(FacesContext context, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getApplicationAttribute(context, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setApplicationAttribute(context, name, value);
        }
        return value;
    }

    public static void setApplicationAttribute(FacesContext context, String name, Object value) {
        FacesLocal.getApplicationMap(context).put(name, value);
    }

    public static <T> T removeApplicationAttribute(FacesContext context, String name) {
        return (T)FacesLocal.getApplicationMap(context).remove(name);
    }

    public static void sendFile(FacesContext context, File file, boolean attachment) throws IOException {
        FacesLocal.sendFile(context, new FileInputStream(file), file.getName(), file.length(), attachment);
    }

    public static void sendFile(FacesContext context, File file, String filename, boolean attachment) throws IOException {
        FacesLocal.sendFile(context, new FileInputStream(file), filename, file.length(), attachment);
    }

    public static void sendFile(FacesContext context, Path path, boolean attachment) throws IOException {
        FacesLocal.sendFile(context, path.toFile(), attachment);
    }

    public static void sendFile(FacesContext context, Path path, String filename, boolean attachment) throws IOException {
        FacesLocal.sendFile(context, path.toFile(), filename, attachment);
    }

    public static void sendFile(FacesContext context, byte[] content, String filename, boolean attachment) {
        FacesLocal.sendFile(context, new ByteArrayInputStream(content), filename, content.length, attachment);
    }

    public static void sendFile(FacesContext context, InputStream content, String filename, boolean attachment) {
        FacesLocal.sendFile(context, content, filename, -1L, attachment);
    }

    public static void sendFile(FacesContext context, String filename, boolean attachment, Callback.Output outputCallback) {
        ExternalContext externalContext = context.getExternalContext();
        externalContext.setResponseBufferSize(10240);
        externalContext.setResponseContentType(FacesLocal.getMimeType(context, filename));
        externalContext.setResponseHeader("Content-Disposition", Servlets.formatContentDispositionHeader(filename, attachment));
        if (Servlets.isSecure((HttpServletRequest)externalContext.getRequest())) {
            externalContext.setResponseHeader("Cache-Control", "public");
            externalContext.setResponseHeader("Pragma", "public");
        }
        try (OutputStream output = externalContext.getResponseOutputStream();){
            outputCallback.writeTo(output);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        context.responseComplete();
    }

    private static void sendFile(FacesContext context, InputStream input, String filename, long contentLength, boolean attachment) {
        FacesLocal.sendFile(context, filename, attachment, output -> {
            ExternalContext externalContext = context.getExternalContext();
            if (contentLength != -1L) {
                externalContext.setResponseHeader("Content-Length", String.valueOf(contentLength));
            }
            long size = Utils.stream(input, output);
            if (contentLength == -1L && !externalContext.isResponseCommitted()) {
                externalContext.setResponseHeader("Content-Length", String.valueOf(size));
            }
        });
    }
}

