/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omnifaces.util.Exceptions;

public final class JNDI {
    public static final String JNDI_NAMESPACE_PREFIX = "java:";
    public static final String JNDI_NAMESPACE_COMPONENT = "java:comp";
    public static final String JNDI_NAMESPACE_GLOBAL = "java:global";
    public static final String JNDI_NAMESPACE_MODULE = "java:module";
    public static final String JNDI_NAMESPACE_APPLICATION = "java:app";
    public static final String JNDI_NAME_PREFIX_ENV_ENTRY = "java:comp/env";
    public static final Pattern PATTERN_EJB_INTERFACE_SUFFIX = Pattern.compile("(LOCAL|REMOTE)$", 2);

    private JNDI() {
    }

    public static <T> T getEnvEntry(String name) {
        return JNDI.lookup("java:comp/env/" + name);
    }

    public static <T> T lookup(String name) {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(name);
            return (T)object;
        }
        catch (NamingException e) {
            if (Exceptions.is(e, NameNotFoundException.class)) {
                T t = null;
                return t;
            }
            throw new IllegalStateException(e);
        }
        finally {
            JNDI.close(context);
        }
    }

    private static void close(InitialContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String guessJNDIName(Class<?> beanClass) {
        return JNDI.guessJNDIName(beanClass.getName());
    }

    public static String guessJNDIName(String className) {
        String lookupname = className.substring(className.lastIndexOf(".") + 1);
        return PATTERN_EJB_INTERFACE_SUFFIX.matcher(lookupname).replaceFirst("") + "!" + className;
    }
}

