/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import javax.faces.validator.ValidatorException;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Messages {
    private static final String ERROR_RESOLVER_ALREADY_SET = "The resolver can be set only once.";
    private static final Resolver DEFAULT_RESOLVER;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) {
        if (Messages.resolver != DEFAULT_RESOLVER) {
            throw new IllegalStateException(ERROR_RESOLVER_ALREADY_SET);
        }
        Messages.resolver = resolver;
    }

    private Messages() {
    }

    public static Message create(String message, Object ... params) {
        return new Message(Messages.createInfo(message, params));
    }

    public static FacesMessage create(FacesMessage.Severity severity, String message, Object ... params) {
        return new FacesMessage(severity, resolver.getMessage(message, params), null);
    }

    public static FacesMessage createInfo(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_INFO, message, params);
    }

    public static FacesMessage createWarn(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_WARN, message, params);
    }

    public static FacesMessage createError(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_ERROR, message, params);
    }

    public static FacesMessage createFatal(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_FATAL, message, params);
    }

    public static ConverterException asConverterException(String message, Object ... params) {
        return new ConverterException(Messages.createError(message, params));
    }

    public static ValidatorException asValidatorException(String message, Object ... params) {
        return new ValidatorException(Messages.createError(message, params));
    }

    public static void throwConverterException(String message, Object ... params) {
        throw Messages.asConverterException(message, params);
    }

    public static void throwValidatorException(String message, Object ... params) {
        throw Messages.asValidatorException(message, params);
    }

    public static void add(String clientId, FacesMessage message) {
        Faces.getContext().addMessage(clientId, message);
    }

    public static void add(FacesMessage.Severity severity, String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.create(severity, message, params));
    }

    public static void addInfo(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createInfo(message, params));
    }

    public static void addWarn(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createWarn(message, params));
    }

    public static void addError(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createError(message, params));
    }

    public static void addFatal(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createFatal(message, params));
    }

    public static void addGlobal(FacesMessage message) {
        Messages.add(null, message);
    }

    public static void addGlobal(FacesMessage.Severity severity, String message, Object ... params) {
        Messages.addGlobal(Messages.create(severity, message, params));
    }

    public static void addGlobalInfo(String message, Object ... params) {
        Messages.addGlobal(Messages.createInfo(message, params));
    }

    public static void addGlobalWarn(String message, Object ... params) {
        Messages.addGlobal(Messages.createWarn(message, params));
    }

    public static void addGlobalError(String message, Object ... params) {
        Messages.addGlobal(Messages.createError(message, params));
    }

    public static void addGlobalFatal(String message, Object ... params) {
        Messages.addGlobal(Messages.createFatal(message, params));
    }

    public static void addFlash(String clientId, FacesMessage message) {
        Faces.getFlash().setKeepMessages(true);
        Messages.add(clientId, message);
    }

    public static void addFlash(FacesMessage.Severity severity, String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.create(severity, message, params));
    }

    public static void addFlashInfo(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createInfo(message, params));
    }

    public static void addFlashWarn(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createWarn(message, params));
    }

    public static void addFlashError(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createError(message, params));
    }

    public static void addFlashFatal(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createFatal(message, params));
    }

    public static void addFlashGlobal(FacesMessage message) {
        Messages.addFlash(null, message);
    }

    public static void addFlashGlobalInfo(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createInfo(message, params));
    }

    public static void addFlashGlobalWarn(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createWarn(message, params));
    }

    public static void addFlashGlobalError(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createError(message, params));
    }

    public static void addFlashGlobalFatal(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createFatal(message, params));
    }

    public static boolean isEmpty() {
        return Faces.getContext().getMessageList().isEmpty();
    }

    public static boolean isEmpty(String clientId) {
        return Faces.getContext().getMessageList(clientId).isEmpty();
    }

    public static boolean isGlobalEmpty() {
        return Messages.isEmpty(null);
    }

    public static boolean clear(FacesMessage.Severity severity, String ... clientIds) {
        if (Utils.isEmpty(clientIds)) {
            return Messages.clear(Faces.getContext().getMessages(), severity);
        }
        return Utils.stream(clientIds).map(clientId -> Messages.clear(Faces.getContext().getMessages(clientId), severity)).collect(Collectors.toSet()).contains(true);
    }

    private static boolean clear(Iterator<FacesMessage> iterator, FacesMessage.Severity severity) {
        boolean atLeastOneCleared = false;
        while (iterator.hasNext()) {
            FacesMessage facesMessage = iterator.next();
            if (severity != null && !severity.equals(facesMessage.getSeverity())) continue;
            iterator.remove();
            atLeastOneCleared = true;
        }
        return atLeastOneCleared;
    }

    public static boolean clear(String ... clientIds) {
        return Messages.clear(null, clientIds);
    }

    public static boolean clearInfo(String ... clientIds) {
        return Messages.clear(FacesMessage.SEVERITY_INFO, clientIds);
    }

    public static boolean clearWarn(String ... clientIds) {
        return Messages.clear(FacesMessage.SEVERITY_WARN, clientIds);
    }

    public static boolean clearError(String ... clientIds) {
        return Messages.clear(FacesMessage.SEVERITY_ERROR, clientIds);
    }

    public static boolean clearFatal(String ... clientIds) {
        return Messages.clear(FacesMessage.SEVERITY_FATAL, clientIds);
    }

    public static boolean clearGlobal(FacesMessage.Severity severity) {
        return Messages.clear(severity, new String[]{null});
    }

    public static boolean clearGlobal() {
        return Messages.clear((FacesMessage.Severity)null, new String[]{null});
    }

    public static boolean clearGlobalInfo() {
        return Messages.clearInfo(new String[]{null});
    }

    public static boolean clearGlobalWarn() {
        return Messages.clearWarn(new String[]{null});
    }

    public static boolean clearGlobalError() {
        return Messages.clearError(new String[]{null});
    }

    public static boolean clearGlobalFatal() {
        return Messages.clearFatal(new String[]{null});
    }

    static {
        resolver = DEFAULT_RESOLVER = (message, params) -> Utils.isEmpty(params) ? message : MessageFormat.format(message, params);
    }

    public static final class Message {
        private FacesMessage facesMessage;

        private Message(FacesMessage facesMessage) {
            this.facesMessage = facesMessage;
        }

        public Message detail(String detail, Object ... params) {
            this.facesMessage.setDetail(resolver.getMessage(detail, params));
            return this;
        }

        public Message warn() {
            this.facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            return this;
        }

        public Message error() {
            this.facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
            return this;
        }

        public Message fatal() {
            this.facesMessage.setSeverity(FacesMessage.SEVERITY_FATAL);
            return this;
        }

        public Message flash() {
            Faces.getFlash().setKeepMessages(true);
            return this;
        }

        public void add(String clientId) {
            Messages.add(clientId, this.facesMessage);
        }

        public void add() {
            Messages.addGlobal(this.facesMessage);
        }

        public FacesMessage get() {
            return this.facesMessage;
        }

        public ConverterException asConverterException() {
            return new ConverterException(this.facesMessage);
        }

        public ValidatorException asValidatorException() {
            return new ValidatorException(this.facesMessage);
        }

        public void throwConverterException() {
            throw this.asConverterException();
        }

        public void throwValidatorException() {
            throw this.asValidatorException();
        }
    }

    public static interface Resolver {
        public String getMessage(String var1, Object ... var2);
    }
}

