/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Reflection;

public final class Validators {
    private static final Logger logger = Logger.getLogger(Validators.class.getName());
    public static final String BEAN_VALIDATION_AVAILABLE = "org.omnifaces.BEAN_VALIDATION_AVAILABLE";
    private static final String ERROR_RESOLVE_BASE = "Cannot resolve base from property '%s' of bean '%s'.";
    private static final String ERROR_ACCESS_KEY = "Cannot access '%s' of '%s' by key '%s'.";
    private static final String ERROR_ACCESS_INDEX = "Cannot access '%s' of '%s' by index '%s'.";

    private Validators() {
    }

    public static boolean isBeanValidationAvailable() {
        return Faces.getApplicationAttribute(BEAN_VALIDATION_AVAILABLE, () -> {
            try {
                Class.forName("javax.validation.Validation");
                Validators.getBeanValidator();
                return true;
            }
            catch (Exception | LinkageError e) {
                logger.log(Level.WARNING, "Bean validation not available.", e);
                return false;
            }
        });
    }

    public static ValidatorFactory getBeanValidatorFactory() {
        return Faces.getApplicationAttribute("javax.faces.validator.beanValidator.ValidatorFactory", Validation::buildDefaultValidatorFactory);
    }

    public static Validator getBeanValidator() {
        ValidatorFactory validatorFactory = Validators.getBeanValidatorFactory();
        return validatorFactory.usingContext().messageInterpolator((MessageInterpolator)new FacesLocaleAwareMessageInterpolator(validatorFactory.getMessageInterpolator())).getValidator();
    }

    public static Set<ConstraintViolation<?>> validateBean(Object bean, Class<?> ... groups) {
        Set violationsRaw;
        Set violations = violationsRaw = Validators.getBeanValidator().validate(bean, (Class[])groups);
        return violations;
    }

    public static Set<ConstraintViolation<?>> validateBeanProperty(Class<?> beanType, String propertyName, Object value, Class<?> ... groups) {
        Set violationsRaw;
        Set violations = violationsRaw = Validators.getBeanValidator().validateValue(beanType, propertyName, value, (Class[])groups);
        return violations;
    }

    public static Object resolveViolatedBase(Object bean, ConstraintViolation<?> violation) {
        List<Map.Entry<Object, String>> basesAndProperties = Validators.resolveViolatedBasesAndProperties(bean, violation);
        return basesAndProperties.isEmpty() ? null : basesAndProperties.iterator().next().getKey();
    }

    public static List<Map.Entry<Object, String>> resolveViolatedBasesAndProperties(Object bean, ConstraintViolation<?> violation) {
        ArrayList<Map.Entry<Object, String>> basesAndProperties;
        block4: {
            basesAndProperties = new ArrayList<Map.Entry<Object, String>>();
            BiConsumer<Object, String> add = (base, property) -> basesAndProperties.add(0, new AbstractMap.SimpleEntry<Object, String>(Beans.unwrapIfNecessary(base), (String)property));
            try {
                Object base2 = bean;
                Iterator iterator = violation.getPropertyPath().iterator();
                while (iterator.hasNext()) {
                    Path.Node node = (Path.Node)iterator.next();
                    add.accept(base2, node.toString());
                    if (base2 != null) {
                        boolean last = !iterator.hasNext();
                        base2 = Validators.resolveProperty(node, base2, last);
                        if (!last) continue;
                        add.accept(base2, Validators.resolveViolatedProperty(violation));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                String propertyPath = Validators.getPropertyNodes(violation).stream().map(Path.Node::toString).collect(Collectors.joining("."));
                logger.log(Level.WARNING, String.format(ERROR_RESOLVE_BASE, propertyPath, bean == null ? "null" : bean.getClass()), e);
                if (violation.getLeafBean() == null) break block4;
                add.accept(violation.getLeafBean(), Validators.resolveViolatedProperty(violation));
            }
        }
        return basesAndProperties;
    }

    public static String resolveViolatedProperty(ConstraintViolation<?> violation) {
        List<Path.Node> propertyNodes = Validators.getPropertyNodes(violation);
        return propertyNodes.get(propertyNodes.size() - 1).getName();
    }

    public static List<Path.Node> getPropertyNodes(ConstraintViolation<?> violation) {
        return StreamSupport.stream(violation.getPropertyPath().spliterator(), false).collect(Collectors.toList());
    }

    private static Object resolveProperty(Path.Node node, Object base, boolean last) {
        ElementKind kind = node.getKind();
        switch (kind) {
            case BEAN: {
                if (node.getIndex() != null || node.getKey() != null || node.getName() != null) {
                    return Validators.resolveProperty(base, node, last);
                }
                return base;
            }
            case CONTAINER_ELEMENT: {
                return Validators.resolveProperty(base, node, last);
            }
            case PROPERTY: {
                if (!last || node.getIndex() != null || node.getKey() != null) {
                    return Validators.resolveProperty(base, node, last);
                }
                return base;
            }
        }
        throw new UnsupportedOperationException(node + " kind " + kind + " is not supported.");
    }

    private static Object resolveProperty(Object base, Path.Node node, boolean last) {
        Object value = node.getIndex() != null ? Validators.accessIndex(base, node) : (node.getKey() != null ? Validators.accessKey(base, node) : base);
        if (node.getName() != null && !last) {
            return Reflection.getBeanProperty(value, node.getName());
        }
        if (node.getIndex() != null || node.getKey() != null) {
            return value;
        }
        throw new UnsupportedOperationException(String.format(ERROR_RESOLVE_BASE, node, base.getClass()));
    }

    private static Object accessIndex(Object base, Path.Node node) {
        int index = node.getIndex();
        if (base instanceof List) {
            return ((List)base).get(index);
        }
        if (base.getClass().isArray()) {
            return Array.get(base, index);
        }
        throw new UnsupportedOperationException(String.format(ERROR_ACCESS_INDEX, node, base.getClass(), index));
    }

    private static Object accessKey(Object base, Path.Node node) {
        Object key = node.getKey();
        if (base instanceof Map) {
            return ((Map)base).get(key);
        }
        throw new UnsupportedOperationException(String.format(ERROR_ACCESS_KEY, node, base.getClass(), key));
    }

    private static class FacesLocaleAwareMessageInterpolator
    implements MessageInterpolator {
        private MessageInterpolator wrapped;

        public FacesLocaleAwareMessageInterpolator(MessageInterpolator wrapped) {
            this.wrapped = wrapped;
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            return this.wrapped.interpolate(message, context, Faces.getLocale());
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.wrapped.interpolate(message, context, locale);
        }
    }
}

