/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Xml {
    private static final Logger logger = Logger.getLogger(Xml.class.getName());

    private Xml() {
    }

    public static Document createDocument(List<URL> urls) throws IOException, SAXException {
        DocumentBuilder builder = Xml.createDocumentBuilder();
        Document document = builder.newDocument();
        document.appendChild(document.createElement("root"));
        Xml.parseAndAppendChildren(builder, document, urls);
        return document;
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setExpandEntityReferences(false);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Xml.unsetAttributeIgnoringIAE(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD");
            Xml.unsetAttributeIgnoringIAE(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema");
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static void unsetAttributeIgnoringIAE(DocumentBuilderFactory factory, String name) {
        try {
            factory.setAttribute(name, "");
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, String.format("Cannot unset attribute '%s'; falling back to default.", name), e);
        }
    }

    public static void parseAndAppendChildren(DocumentBuilder builder, Document document, List<URL> urls) throws IOException, SAXException {
        for (URL url : urls) {
            if (url == null) continue;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            try {
                InputStream input = connection.getInputStream();
                Throwable throwable = null;
                try {
                    NodeList children = builder.parse(input).getDocumentElement().getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        document.getDocumentElement().appendChild(document.importNode(children.item(i), true));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (SAXParseException e) {
                throw new SAXException("Cannot parse " + url.toExternalForm(), e);
            }
        }
    }

    public static NodeList getNodeList(Node node, XPath xpath, String expression) throws XPathExpressionException {
        return (NodeList)xpath.compile(expression).evaluate(node, XPathConstants.NODESET);
    }

    public static String getTextContent(Node node) {
        return node.getFirstChild().getNodeValue().trim();
    }

    public static List<String> getNodeTextContents(URL url, String expression) {
        try {
            NodeList nodeList = Xml.getNodeList(Xml.createDocument(Arrays.asList(url)).getDocumentElement(), XPathFactory.newInstance().newXPath(), expression);
            ArrayList<String> nodeTextContents = new ArrayList<String>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeTextContents.add(Xml.getTextContent(nodeList.item(i)));
            }
            return nodeTextContents;
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

