/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.cache;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.omnifaces.util.cache.Cache;
import org.omnifaces.util.cache.CacheProvider;
import org.omnifaces.util.cache.DefaultCacheProvider;

public abstract class CacheInstancePerScopeProvider
implements CacheProvider {
    public static final String DEFAULT_CACHE_PARAM_NAME = "org.omnifaces.defaultcache";
    public static final String APP_TTL_PARAM_NAME = "APPLICATION_TTL";
    public static final String SESSION_TTL_PARAM_NAME = "SESSION_TTL";
    public static final String APP_MAX_CAP_PARAM_NAME = "APPLICATION_MAX_CAPACITY";
    public static final String SESSION_MAX_CAP_PARAM_NAME = "SESSION_MAX_CAPACITY";
    private Integer appDefaultTimeToLive;
    private Integer sessionDefaultTimeToLive;
    private Integer appMaxCapacity;
    private Integer sessionMaxCapacity;
    private Map<String, String> parameters;

    @Override
    public Cache getCache(FacesContext context, String scope) {
        if ("application".equals(scope)) {
            return this.getAppScopeCache(context);
        }
        if ("session".equals(scope)) {
            return this.getSessionScopeCache(context);
        }
        throw new IllegalArgumentException("Scope " + scope + " not supported by provider" + DefaultCacheProvider.class.getName());
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        if (parameters.containsKey(APP_TTL_PARAM_NAME)) {
            this.appDefaultTimeToLive = Integer.valueOf(parameters.get(APP_TTL_PARAM_NAME));
        }
        if (parameters.containsKey(SESSION_TTL_PARAM_NAME)) {
            this.sessionDefaultTimeToLive = Integer.valueOf(parameters.get(SESSION_TTL_PARAM_NAME));
        }
        if (parameters.containsKey(APP_MAX_CAP_PARAM_NAME)) {
            this.appMaxCapacity = Integer.valueOf(parameters.get(APP_MAX_CAP_PARAM_NAME));
        }
        if (parameters.containsKey(SESSION_MAX_CAP_PARAM_NAME)) {
            this.sessionMaxCapacity = Integer.valueOf(parameters.get(SESSION_MAX_CAP_PARAM_NAME));
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache getAppScopeCache(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        if (applicationMap.containsKey(DEFAULT_CACHE_PARAM_NAME)) return (Cache)applicationMap.get(DEFAULT_CACHE_PARAM_NAME);
        Class<DefaultCacheProvider> clazz = DefaultCacheProvider.class;
        synchronized (DefaultCacheProvider.class) {
            if (applicationMap.containsKey(DEFAULT_CACHE_PARAM_NAME)) return (Cache)applicationMap.get(DEFAULT_CACHE_PARAM_NAME);
            applicationMap.put(DEFAULT_CACHE_PARAM_NAME, this.createCache(this.appDefaultTimeToLive, this.appMaxCapacity));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (Cache)applicationMap.get(DEFAULT_CACHE_PARAM_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getSessionScopeCache(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (!sessionMap.containsKey(DEFAULT_CACHE_PARAM_NAME)) {
            Object session;
            Object object = session = context.getExternalContext().getSession(true);
            synchronized (object) {
                if (!sessionMap.containsKey(DEFAULT_CACHE_PARAM_NAME)) {
                    sessionMap.put(DEFAULT_CACHE_PARAM_NAME, this.createCache(this.sessionDefaultTimeToLive, this.sessionMaxCapacity));
                }
            }
        }
        return (Cache)sessionMap.get(DEFAULT_CACHE_PARAM_NAME);
    }

    protected abstract Cache createCache(Integer var1, Integer var2);
}

