/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.copier;

import java.lang.reflect.Method;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.copier.Copier;

public class CloneCopier
implements Copier {
    private static final String ERROR_MISSING_INTERFACE = "Can not clone object of type %s because it doesn't implement Cloneable, you need to make sure that the class implements java.lang.Cloneable";
    private static final String ERROR_INACCESSIBLE_METHOD = "Can not clone object of type %s because clone() method is not accessible, you need to make sure that the clone() method is overridden and that it is public instead of protected";
    private static final String ERROR_UNINVOKABLE_METHOD = "Can not clone object of type %s because clone() method is not invokable, you need to make sure that invoking the clone() method does not throw an exception";

    @Override
    public Object copy(Object object) {
        if (!(object instanceof Cloneable)) {
            throw new IllegalStateException(String.format(ERROR_MISSING_INTERFACE, object.getClass()));
        }
        Method method = Reflection.findMethod(object, "clone", new Object[0]);
        Method canAccess = Reflection.findMethod(method, "canAccess", object);
        if (canAccess != null && !((Boolean)Reflection.invokeMethod((Object)method, canAccess, object)).booleanValue()) {
            throw new IllegalStateException(String.format(ERROR_INACCESSIBLE_METHOD, object.getClass()));
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_UNINVOKABLE_METHOD, object.getClass()));
        }
    }
}

