/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.viewhandler;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

public class NoAutoGeneratedIdViewHandler
extends ViewHandlerWrapper {
    private static final Logger logger = Logger.getLogger(NoAutoGeneratedIdViewHandler.class.getName());
    private static final String WARNING_PREPENDID_FALSE_ENCOUNTERED = "prependId=false encountered on component type %s. This is bad practice, see also https://stackoverflow.com/a/7416770/157882";
    private static final String ERROR_AUTO_GENERATED_ID_ENCOUNTERED = "Auto generated ID '%s' encountered on component type %s.";

    public NoAutoGeneratedIdViewHandler(ViewHandler wrapped) {
        super(wrapped);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        super.renderView((FacesContext)(FacesLocal.isDevelopment(context) ? new FacesContextWrapper(context){

            public void setResponseWriter(ResponseWriter responseWriter) {
                super.setResponseWriter((ResponseWriter)new NoAutoGeneratedIdResponseWriter(responseWriter));
            }
        } : context), viewToRender);
    }

    public static class NoAutoGeneratedIdResponseWriter
    extends ResponseWriterWrapper {
        private final char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)Faces.getContext());
        private final String intermediateIdPrefix = this.separatorChar + "j_id";

        public NoAutoGeneratedIdResponseWriter(ResponseWriter wrapped) {
            super(wrapped);
        }

        public ResponseWriter cloneWithWriter(Writer writer) {
            return new NoAutoGeneratedIdResponseWriter(super.cloneWithWriter(writer));
        }

        public void startElement(String name, UIComponent component) throws IOException {
            if (component != null && Boolean.FALSE.equals(component.getAttributes().get("prependId"))) {
                logger.warning(() -> String.format(NoAutoGeneratedIdViewHandler.WARNING_PREPENDID_FALSE_ENCOUNTERED, NoAutoGeneratedIdResponseWriter.getComponentType(component)));
            }
            super.startElement(name, component);
        }

        public void writeAttribute(String name, Object value, String property) throws IOException {
            String id;
            if (value != null && "id".equals(name) && ((id = value.toString()).startsWith("j_id") || id.contains(this.intermediateIdPrefix))) {
                Object component;
                int end = id.indexOf(this.separatorChar, id.indexOf("j_id"));
                if (end > 0) {
                    id = id.substring(0, end);
                }
                if (!((component = Components.findComponentRelatively(Utils.coalesce(Components.getCurrentComponent(), Faces.getViewRoot()), id)) instanceof UIViewRoot)) {
                    String message = String.format(NoAutoGeneratedIdViewHandler.ERROR_AUTO_GENERATED_ID_ENCOUNTERED, id, NoAutoGeneratedIdResponseWriter.getComponentType(component));
                    if (component == null) {
                        logger.warning(message);
                    } else {
                        throw new IllegalStateException(message);
                    }
                }
            }
            super.writeAttribute(name, value, property);
        }

        private static String getComponentType(UIComponent component) {
            return component == null ? "<null>" : component.getClass().getName() + ":" + component.getRendererType();
        }
    }
}

