/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.viewhandler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.render.ResponseStateManager;
import org.omnifaces.cdi.viewscope.ViewScopeManager;
import org.omnifaces.resourcehandler.ViewResourceHandler;
import org.omnifaces.taghandler.EnableRestorableView;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Platform;

public class OmniViewHandler
extends ViewHandlerWrapper {
    private static final String XML_CONTENT_TYPE = "text/xml";
    private static final String ERROR_NESTED_FORM_ENCOUNTERED = "Nested form with ID '%s' encountered inside parent form with ID '%s'. This is illegal in HTML.";

    public OmniViewHandler(ViewHandler wrapped) {
        super(wrapped);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (ViewScopeManager.isUnloadRequest(context)) {
            return this.unloadView(context, viewId);
        }
        UIViewRoot restoredView = super.restoreView(context, viewId);
        if (EnableRestorableView.isRestorableViewRequest(context, restoredView)) {
            return this.createRestorableViewIfNecessary(viewId);
        }
        return restoredView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        if (FacesLocal.isDevelopment(context)) {
            this.validateComponentTreeStructure(context, viewToRender);
        }
        if (FacesLocal.isAjaxRequest(context)) {
            context.getAttributes().put("facelets.ContentType", XML_CONTENT_TYPE);
        }
        if (ViewResourceHandler.isViewResourceRequest(context)) {
            String contentType = FacesLocal.getMimeType(context, FacesLocal.getRequestServletPath(context));
            String characterEncoding = StandardCharsets.UTF_8.name();
            ExternalContext externalContext = context.getExternalContext();
            externalContext.setResponseContentType(contentType);
            externalContext.setResponseCharacterEncoding(characterEncoding);
            context.setResponseWriter(context.getRenderKit().createResponseWriter(externalContext.getResponseOutputWriter(), XML_CONTENT_TYPE, characterEncoding));
            context.getAttributes().put("facelets.ContentType", contentType);
            try {
                Hacks.clearCachedFacesServletMapping(context);
                super.renderView((FacesContext)new RenderViewResourceFacesContext(context), viewToRender);
            }
            finally {
                Hacks.clearCachedFacesServletMapping(context);
            }
        } else {
            super.renderView(context, viewToRender);
        }
    }

    private UIViewRoot unloadView(FacesContext context, String viewId) {
        UIViewRoot createdView = this.createView(context, viewId);
        ResponseStateManager manager = FacesLocal.getRenderKit(context).getResponseStateManager();
        if (this.restoreViewRootState(context, manager, createdView)) {
            context.setProcessingEvents(true);
            context.getApplication().publishEvent(context, PreDestroyViewMapEvent.class, UIViewRoot.class, (Object)createdView);
            Hacks.removeViewState(context, manager, viewId);
        } else if (FacesLocal.isSessionNew(context)) {
            FacesLocal.redirectPermanent(context, FacesLocal.getRequestURIWithQueryString(context), new Object[0]);
        }
        Faces.responseComplete();
        return createdView;
    }

    private boolean restoreViewRootState(FacesContext context, ResponseStateManager manager, UIViewRoot view) {
        Object state = manager.getState(context, view.getViewId());
        if (!(state instanceof Object[]) || ((Object[])state).length < 2) {
            return false;
        }
        Object componentState = ((Object[])state)[1];
        Object viewRootState = null;
        if (componentState instanceof Map) {
            if (view.getId() == null) {
                view.setId(view.createUniqueId(context, null));
                view.markInitialState();
            }
            viewRootState = ((Map)componentState).get(view.getClientId(context));
        } else if (componentState instanceof Object[]) {
            viewRootState = ((Object[])componentState)[0];
        }
        if (viewRootState != null) {
            view.restoreState(context, viewRootState);
            context.setViewRoot(view);
            return true;
        }
        return false;
    }

    private UIViewRoot createRestorableViewIfNecessary(String viewId) {
        try {
            UIViewRoot createdView = Components.buildView(viewId);
            return EnableRestorableView.isRestorableView(createdView) ? createdView : null;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void validateComponentTreeStructure(FacesContext context, UIViewRoot view) {
        this.checkNestedForms(context, (UIComponent)view, null);
    }

    private void checkNestedForms(FacesContext context, UIComponent parent, UIForm nestedParent) {
        for (UIComponent child : parent.getChildren()) {
            UIForm form = null;
            if (child instanceof UIForm) {
                form = (UIForm)child;
                if (nestedParent != null && (!Hacks.isNestedInPrimeFacesDialog(new UIComponent[]{form}) || Hacks.isNestedInPrimeFacesDialog(new UIComponent[]{form, nestedParent}))) {
                    throw new IllegalStateException(String.format(ERROR_NESTED_FORM_ENCOUNTERED, form.getClientId(), nestedParent.getClientId()));
                }
            }
            this.checkNestedForms(context, child, form);
        }
    }

    private static class RenderViewResourceExternalContext
    extends ExternalContextWrapper {
        private final String requestPathInfo;
        private final String requestServletPath;

        private RenderViewResourceExternalContext(ExternalContext wrapped, String requestPathInfo, String requestServletPath) {
            super(wrapped);
            this.requestPathInfo = requestPathInfo;
            this.requestServletPath = requestServletPath;
        }

        public String getRequestPathInfo() {
            return this.requestPathInfo;
        }

        public String getRequestServletPath() {
            return this.requestServletPath;
        }

        public String encodeActionURL(String url) {
            return super.encodeActionURL(url).replaceAll(";jsessionid=[^&?#]*", "");
        }
    }

    private static class RenderViewResourceFacesContext
    extends FacesContextWrapper {
        private final ExternalContext externalContext;

        private RenderViewResourceFacesContext(FacesContext wrapped) {
            super(wrapped);
            String defaultMapping = Platform.getDefaultFacesServletMapping(FacesLocal.getServletContext(this.getWrapped()));
            boolean prefixMapping = Faces.isPrefixMapping(defaultMapping);
            String requestPathInfo = prefixMapping ? defaultMapping : null;
            String requestServletPath = FacesLocal.getRequestServletPath(this.getWrapped()) + (prefixMapping ? "" : defaultMapping);
            this.externalContext = new RenderViewResourceExternalContext(this.getWrapped().getExternalContext(), requestPathInfo, requestServletPath);
        }

        public ExternalContext getExternalContext() {
            return this.externalContext;
        }
    }
}

