/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import org.openjdk.jol.info.FieldData;

public class FieldLayout
implements Comparable<FieldLayout> {
    private final FieldData f;
    private final long size;
    private final long offset;

    public FieldLayout(FieldData fieldData, long offset, long size) {
        this.f = fieldData;
        this.size = size;
        this.offset = offset;
    }

    public long offset() {
        return this.offset;
    }

    public long size() {
        return this.size;
    }

    public String typeClass() {
        return this.f.typeClass();
    }

    public String hostClass() {
        return this.f.hostClass();
    }

    public String name() {
        return this.f.name();
    }

    public String shortFieldName() {
        String cl = this.hostClass();
        int idx = cl.lastIndexOf(".");
        if (idx != -1 && idx < cl.length()) {
            return cl.substring(idx + 1) + "." + this.f.name();
        }
        return cl + "." + this.name();
    }

    FieldData data() {
        return this.f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldLayout that = (FieldLayout)o;
        return this.offset == that.offset;
    }

    public int hashCode() {
        return (int)(this.offset ^ this.offset >>> 32);
    }

    @Override
    public int compareTo(FieldLayout o) {
        return Long.valueOf(this.offset).compareTo(o.offset);
    }

    public String toString() {
        return this.f.hostClass() + "." + this.f.name() + " @" + this.offset + " (" + this.typeClass() + ", " + this.size + "b)";
    }
}

