/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.openjdk.jol.info.ArrayGraphPathRecord;
import org.openjdk.jol.info.FieldGraphPathRecord;
import org.openjdk.jol.info.GraphPathRecord;
import org.openjdk.jol.info.GraphVisitor;
import org.openjdk.jol.util.ObjectUtils;

public class GraphWalker {
    private final Set<Object> visited;
    private final Object[] roots;
    private final Collection<GraphVisitor> visitors;
    private final Map<Class<?>, Field[]> fieldsCache;

    public GraphWalker(Object ... roots) {
        this.roots = roots;
        this.visited = Collections.newSetFromMap(new IdentityHashMap());
        this.visitors = new ArrayList<GraphVisitor>();
        this.fieldsCache = new HashMap();
    }

    public void addVisitor(GraphVisitor v) {
        this.visitors.add(v);
    }

    public void walk() {
        ArrayList<FieldGraphPathRecord> curLayer = new ArrayList<FieldGraphPathRecord>();
        ArrayList<GraphPathRecord> newLayer = new ArrayList<GraphPathRecord>();
        int rootId = 1;
        boolean single = this.roots.length == 1;
        for (Object root : this.roots) {
            String label = single ? "" : "<r" + rootId + ">";
            FieldGraphPathRecord e = new FieldGraphPathRecord(null, label, 0, root);
            if (this.visited.add(root)) {
                this.visitObject(e);
                curLayer.add(e);
            }
            ++rootId;
        }
        while (!curLayer.isEmpty()) {
            newLayer.clear();
            for (GraphPathRecord graphPathRecord : curLayer) {
                Field[] fields;
                Object o = graphPathRecord.obj();
                if (o.getClass().isArray()) {
                    if (o.getClass().getComponentType().isPrimitive()) continue;
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Object e = arr[i];
                        if (e == null || !this.visited.add(e)) continue;
                        ArrayGraphPathRecord gpr = new ArrayGraphPathRecord(graphPathRecord, i, graphPathRecord.depth() + 1, e);
                        this.visitObject(gpr);
                        newLayer.add(gpr);
                    }
                    continue;
                }
                for (Field f : fields = this.getAllReferences(o.getClass())) {
                    Object e = ObjectUtils.value(o, f);
                    if (e == null || !this.visited.add(e)) continue;
                    FieldGraphPathRecord gpr = new FieldGraphPathRecord(graphPathRecord, f.getName(), graphPathRecord.depth() + 1, e);
                    this.visitObject(gpr);
                    newLayer.add(gpr);
                }
            }
            curLayer.clear();
            curLayer.addAll(newLayer);
        }
    }

    private void visitObject(GraphPathRecord record) {
        for (GraphVisitor v : this.visitors) {
            v.visit(record);
        }
    }

    private Field[] getAllReferences(Class<?> klass) {
        Field[] exist = this.fieldsCache.get(klass);
        if (exist != null) {
            return exist;
        }
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
            results.add(f);
        }
        Class<?> superKlass = klass;
        while ((superKlass = superKlass.getSuperclass()) != null) {
            for (Field f : superKlass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                results.add(f);
            }
        }
        Field[] arr = results.toArray(new Field[0]);
        this.fieldsCache.put(klass, arr);
        return arr;
    }
}

